/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerConfigurationTemplate
implements JsonTemplate {
    private String architecture = "amd64";
    private String os = "linux";
    private final ConfigurationObjectTemplate config = new ConfigurationObjectTemplate();
    private final RootFilesystemObjectTemplate rootfs = new RootFilesystemObjectTemplate();

    public void setContainerEnvironment(List<String> environment) {
        this.config.Env = environment;
    }

    public void setContainerEntrypoint(List<String> command) {
        this.config.Entrypoint = command;
    }

    public void addLayerDiffId(DescriptorDigest diffId) {
        this.rootfs.diff_ids.add(diffId);
    }

    List<DescriptorDigest> getDiffIds() {
        return this.rootfs.diff_ids;
    }

    List<String> getContainerEnvironment() {
        return this.config.Env;
    }

    List<String> getContainerEntrypoint() {
        return this.config.Entrypoint;
    }

    @VisibleForTesting
    DescriptorDigest getLayerDiffId(int index) {
        return (DescriptorDigest)this.rootfs.diff_ids.get(index);
    }

    private static class RootFilesystemObjectTemplate
    implements JsonTemplate {
        private final String type = "layers";
        private final List<DescriptorDigest> diff_ids = new ArrayList<DescriptorDigest>();

        private RootFilesystemObjectTemplate() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConfigurationObjectTemplate
    implements JsonTemplate {
        private List<String> Env;
        private List<String> Entrypoint;

        private ConfigurationObjectTemplate() {
        }
    }
}

