/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class BlobChecker
implements RegistryEndpointProvider<BlobDescriptor> {
    private final RegistryEndpointProperties registryEndpointProperties;
    private final DescriptorDigest blobDigest;

    BlobChecker(RegistryEndpointProperties registryEndpointProperties, DescriptorDigest blobDigest) {
        this.registryEndpointProperties = registryEndpointProperties;
        this.blobDigest = blobDigest;
    }

    @Override
    public BlobDescriptor handleResponse(Response response) throws RegistryErrorException {
        long contentLength = response.getContentLength();
        if (contentLength < 0L) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription()).addReason("Did not receive Content-Length header").build();
        }
        return new BlobDescriptor(contentLength, this.blobDigest);
    }

    @Override
    public BlobDescriptor handleHttpResponseException(HttpResponseException httpResponseException) throws RegistryErrorException, HttpResponseException {
        if (httpResponseException.getStatusCode() != 404) {
            throw httpResponseException;
        }
        String errorContent = httpResponseException.getContent();
        if (errorContent == null) {
            return null;
        }
        try {
            ErrorCodes errorCode;
            ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(errorContent, ErrorResponseTemplate.class);
            List<ErrorEntryTemplate> errors = errorResponse.getErrors();
            if (errors.size() == 1 && (errorCode = ErrorCodes.valueOf(errors.get(0).getCode())).equals((Object)ErrorCodes.BLOB_UNKNOWN)) {
                return null;
            }
        }
        catch (IOException ex) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), ex).addReason("Failed to parse registry error response body").build();
        }
        throw httpResponseException;
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointProperties.getImageName() + "/blobs/" + this.blobDigest);
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public String getHttpMethod() {
        return "HEAD";
    }

    @Override
    public String getActionDescription() {
        return "check BLOB exists for " + this.registryEndpointProperties.getServerUrl() + "/" + this.registryEndpointProperties.getImageName() + " with digest " + this.blobDigest;
    }
}

