/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheReader;
import com.google.cloud.tools.jib.cache.CacheWriter;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.image.LayerBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayersStep
implements Callable<List<ListenableFuture<CachedLayer>>> {
    private static final String DESCRIPTION = "Building application layers";
    private final BuildConfiguration buildConfiguration;
    private final SourceFilesConfiguration sourceFilesConfiguration;
    private final Cache cache;
    private final ListeningExecutorService listeningExecutorService;

    BuildAndCacheApplicationLayersStep(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Cache cache, ListeningExecutorService listeningExecutorService) {
        this.buildConfiguration = buildConfiguration;
        this.sourceFilesConfiguration = sourceFilesConfiguration;
        this.cache = cache;
        this.listeningExecutorService = listeningExecutorService;
    }

    @Override
    public List<ListenableFuture<CachedLayer>> call() {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            ArrayList<ListenableFuture<CachedLayer>> applicationLayerFutures = new ArrayList<ListenableFuture<CachedLayer>>(3);
            applicationLayerFutures.add(this.buildAndCacheLayerAsync("dependencies", this.sourceFilesConfiguration.getDependenciesFiles(), this.sourceFilesConfiguration.getDependenciesPathOnImage()));
            applicationLayerFutures.add(this.buildAndCacheLayerAsync("resources", this.sourceFilesConfiguration.getResourcesFiles(), this.sourceFilesConfiguration.getResourcesPathOnImage()));
            applicationLayerFutures.add(this.buildAndCacheLayerAsync("classes", this.sourceFilesConfiguration.getClassesFiles(), this.sourceFilesConfiguration.getClassesPathOnImage()));
            ArrayList<ListenableFuture<CachedLayer>> arrayList = applicationLayerFutures;
            return arrayList;
        }
    }

    private ListenableFuture<CachedLayer> buildAndCacheLayerAsync(String layerType, List<Path> sourceFiles, String extractionPath) {
        String description = "Building " + layerType + " layer";
        return this.listeningExecutorService.submit(() -> {
            Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), description);
            Throwable throwable = null;
            try {
                CachedLayer cachedLayer = new CacheReader(this.cache).getUpToDateLayerBySourceFiles(sourceFiles);
                if (cachedLayer != null) {
                    CachedLayer cachedLayer2 = cachedLayer;
                    return cachedLayer2;
                }
                LayerBuilder layerBuilder = new LayerBuilder(sourceFiles, extractionPath, this.buildConfiguration.getEnableReproducibleBuilds());
                cachedLayer = new CacheWriter(this.cache).writeLayer(layerBuilder);
                this.buildConfiguration.getBuildLogger().debug(description + " built " + cachedLayer.getBlobDescriptor().getDigest());
                CachedLayer cachedLayer3 = cachedLayer;
                return cachedLayer3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                BuildAndCacheApplicationLayersStep.$closeResource(throwable, ignored);
            }
        });
    }
}

