/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class BuildConfiguration {
    private final BuildLogger buildLogger;
    private ImageReference baseImageReference;
    private ImageReference targetImageReference;
    private List<String> credentialHelperNames;
    private RegistryCredentials knownRegistryCredentials;
    private boolean enableReproducibleBuilds;
    private String mainClass;
    private List<String> jvmFlags;
    private Map<String, String> environmentMap;
    private Class<? extends BuildableManifestTemplate> targetFormat;

    public static Builder builder(BuildLogger buildLogger) {
        return new Builder(buildLogger);
    }

    private BuildConfiguration(BuildLogger buildLogger, ImageReference baseImageReference, ImageReference targetImageReference, List<String> credentialHelperNames, RegistryCredentials knownRegistryCredentials, boolean enableReproducibleBuilds, String mainClass, List<String> jvmFlags, Map<String, String> environmentMap, Class<? extends BuildableManifestTemplate> targetFormat) {
        this.buildLogger = buildLogger;
        this.baseImageReference = baseImageReference;
        this.targetImageReference = targetImageReference;
        this.credentialHelperNames = Collections.unmodifiableList(credentialHelperNames);
        this.knownRegistryCredentials = knownRegistryCredentials;
        this.enableReproducibleBuilds = enableReproducibleBuilds;
        this.mainClass = mainClass;
        this.jvmFlags = Collections.unmodifiableList(jvmFlags);
        this.environmentMap = Collections.unmodifiableMap(environmentMap);
        this.targetFormat = targetFormat;
    }

    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    public String getBaseImageRegistry() {
        return this.baseImageReference.getRegistry();
    }

    public String getBaseImageRepository() {
        return this.baseImageReference.getRepository();
    }

    public String getBaseImageTag() {
        return this.baseImageReference.getTag();
    }

    public String getTargetRegistry() {
        return this.targetImageReference.getRegistry();
    }

    public String getTargetRepository() {
        return this.targetImageReference.getRepository();
    }

    public String getTargetTag() {
        return this.targetImageReference.getTag();
    }

    public RegistryCredentials getKnownRegistryCredentials() {
        return this.knownRegistryCredentials;
    }

    public List<String> getCredentialHelperNames() {
        return this.credentialHelperNames;
    }

    public boolean getEnableReproducibleBuilds() {
        return this.enableReproducibleBuilds;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getJvmFlags() {
        return this.jvmFlags;
    }

    public Map<String, String> getEnvironment() {
        return this.environmentMap;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    public static class Builder {
        @Nullable
        private ImageReference baseImageReference;
        @Nullable
        private ImageReference targetImageReference;
        private List<String> credentialHelperNames = new ArrayList<String>();
        private RegistryCredentials knownRegistryCredentials = RegistryCredentials.none();
        private boolean enableReproducibleBuilds = true;
        @Nullable
        private String mainClass;
        private List<String> jvmFlags = new ArrayList<String>();
        private Map<String, String> environmentMap = new HashMap<String, String>();
        private Class<? extends BuildableManifestTemplate> targetFormat = V22ManifestTemplate.class;
        private BuildLogger buildLogger;

        private Builder(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
        }

        public Builder setBaseImage(@Nullable ImageReference imageReference) {
            this.baseImageReference = imageReference;
            return this;
        }

        public Builder setTargetImage(@Nullable ImageReference imageReference) {
            this.targetImageReference = imageReference;
            return this;
        }

        public Builder setCredentialHelperNames(@Nullable List<String> credentialHelperNames) {
            if (credentialHelperNames != null) {
                this.credentialHelperNames = credentialHelperNames;
            }
            return this;
        }

        public Builder setKnownRegistryCredentials(@Nullable RegistryCredentials knownRegistryCredentials) {
            if (knownRegistryCredentials != null) {
                this.knownRegistryCredentials = knownRegistryCredentials;
            }
            return this;
        }

        public Builder setEnableReproducibleBuilds(boolean isEnabled) {
            this.enableReproducibleBuilds = isEnabled;
            return this;
        }

        public Builder setMainClass(@Nullable String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder setJvmFlags(@Nullable List<String> jvmFlags) {
            if (jvmFlags != null) {
                this.jvmFlags = jvmFlags;
            }
            return this;
        }

        public Builder setEnvironment(@Nullable Map<String, String> environmentMap) {
            if (environmentMap != null) {
                this.environmentMap = environmentMap;
            }
            return this;
        }

        public Builder setTargetFormat(Class<? extends BuildableManifestTemplate> targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        public BuildConfiguration build() {
            ArrayList<String> errorMessages = new ArrayList<String>();
            if (this.baseImageReference == null) {
                errorMessages.add("base image is required but not set");
            }
            if (this.targetImageReference == null) {
                errorMessages.add("target image is required but not set");
            }
            if (this.mainClass == null) {
                errorMessages.add("main class is required but not set");
            }
            switch (errorMessages.size()) {
                case 0: {
                    if (this.baseImageReference == null || this.targetImageReference == null || this.mainClass == null) {
                        throw new IllegalStateException("Required fields should not be null");
                    }
                    return new BuildConfiguration(this.buildLogger, this.baseImageReference, this.targetImageReference, this.credentialHelperNames, this.knownRegistryCredentials, this.enableReproducibleBuilds, this.mainClass, this.jvmFlags, this.environmentMap, this.targetFormat);
                }
                case 1: {
                    throw new IllegalStateException((String)errorMessages.get(0));
                }
                case 2: {
                    throw new IllegalStateException((String)errorMessages.get(0) + " and " + (String)errorMessages.get(1));
                }
            }
            StringBuilder errorMessage = new StringBuilder((String)errorMessages.get(0));
            for (int errorMessageIndex = 1; errorMessageIndex < errorMessages.size(); ++errorMessageIndex) {
                if (errorMessageIndex == errorMessages.size() - 1) {
                    errorMessage.append(", and ");
                } else {
                    errorMessage.append(", ");
                }
                errorMessage.append((String)errorMessages.get(errorMessageIndex));
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }
}

