/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.AuthenticatePullStep;
import com.google.cloud.tools.jib.builder.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.BuildAndCacheApplicationLayersStep;
import com.google.cloud.tools.jib.builder.BuildAndPushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.EntrypointBuilder;
import com.google.cloud.tools.jib.builder.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.PushImageStep;
import com.google.cloud.tools.jib.builder.PushLayersStep;
import com.google.cloud.tools.jib.builder.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BuildImageSteps {
    private static final String DESCRIPTION = "Building and pushing image";
    private final BuildConfiguration buildConfiguration;
    private final SourceFilesConfiguration sourceFilesConfiguration;
    private final Caches.Initializer cachesInitializer;

    public BuildImageSteps(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Caches.Initializer cachesInitializer) {
        this.buildConfiguration = buildConfiguration;
        this.sourceFilesConfiguration = sourceFilesConfiguration;
        this.cachesInitializer = cachesInitializer;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public void run() throws InterruptedException, ExecutionException, CacheMetadataCorruptedException, IOException, CacheDirectoryNotOwnedException {
        List<String> entrypoint = EntrypointBuilder.makeEntrypoint(this.sourceFilesConfiguration, this.buildConfiguration.getJvmFlags(), this.buildConfiguration.getMainClass());
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);
             Timer timer2 = timer.subTimer("Initializing cache");){
            ListeningExecutorService listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
            try (Caches caches = this.cachesInitializer.init();){
                Cache baseLayersCache = caches.getBaseCache();
                Cache applicationLayersCache = caches.getApplicationCache();
                timer2.lap("Setting up credential retrieval");
                ListenableFuture retrieveTargetRegistryCredentialsFuture = listeningExecutorService.submit((Callable)new RetrieveRegistryCredentialsStep(this.buildConfiguration, this.buildConfiguration.getTargetRegistry()));
                ListenableFuture retrieveBaseImageRegistryCredentialsFuture = listeningExecutorService.submit((Callable)new RetrieveRegistryCredentialsStep(this.buildConfiguration, this.buildConfiguration.getBaseImageRegistry()));
                timer2.lap("Setting up image push authentication");
                ListenableFuture authenticatePushFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{retrieveTargetRegistryCredentialsFuture}).call((Callable)new AuthenticatePushStep(this.buildConfiguration, (ListenableFuture<Authorization>)retrieveTargetRegistryCredentialsFuture), (Executor)listeningExecutorService);
                timer2.lap("Setting up image pull authentication");
                ListenableFuture authenticatePullFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{retrieveBaseImageRegistryCredentialsFuture}).call((Callable)new AuthenticatePullStep(this.buildConfiguration, (ListenableFuture<Authorization>)retrieveBaseImageRegistryCredentialsFuture), (Executor)listeningExecutorService);
                timer2.lap("Setting up base image pull");
                ListenableFuture pullBaseImageFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{authenticatePullFuture}).call((Callable)new PullBaseImageStep(this.buildConfiguration, (Future<Authorization>)authenticatePullFuture), (Executor)listeningExecutorService);
                timer2.lap("Setting up base image layer pull");
                ListenableFuture pullBaseImageLayerFuturesFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullBaseImageFuture}).call((Callable)new PullAndCacheBaseImageLayersStep(this.buildConfiguration, baseLayersCache, listeningExecutorService, (ListenableFuture<Authorization>)authenticatePullFuture, (ListenableFuture<Image>)pullBaseImageFuture), (Executor)listeningExecutorService);
                timer2.lap("Setting up base image layer push");
                ListenableFuture pushBaseImageLayerFuturesFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullBaseImageLayerFuturesFuture}).call((Callable)new PushLayersStep(this.buildConfiguration, listeningExecutorService, (ListenableFuture<Authorization>)authenticatePushFuture, (ListenableFuture<List<ListenableFuture<CachedLayer>>>)pullBaseImageLayerFuturesFuture), (Executor)listeningExecutorService);
                timer2.lap("Setting up build application layers");
                Object buildAndCacheApplicationLayerFutures = new BuildAndCacheApplicationLayersStep(this.buildConfiguration, this.sourceFilesConfiguration, applicationLayersCache, listeningExecutorService).call();
                timer2.lap("Setting up container configuration push");
                ListenableFuture buildAndPushContainerConfigurationFutureFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullBaseImageLayerFuturesFuture}).call((Callable)new BuildAndPushContainerConfigurationStep(this.buildConfiguration, listeningExecutorService, (ListenableFuture<Authorization>)authenticatePushFuture, (ListenableFuture<List<ListenableFuture<CachedLayer>>>)pullBaseImageLayerFuturesFuture, (List<ListenableFuture<CachedLayer>>)buildAndCacheApplicationLayerFutures, entrypoint), (Executor)listeningExecutorService);
                timer2.lap("Setting up application layer push");
                Object pushApplicationLayersFuture = new PushLayersStep(this.buildConfiguration, listeningExecutorService, (ListenableFuture<Authorization>)authenticatePushFuture, (ListenableFuture<List<ListenableFuture<CachedLayer>>>)Futures.immediateFuture((Object)buildAndCacheApplicationLayerFutures)).call();
                timer2.lap("Setting up image manifest push");
                ListenableFuture pushImageFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pushBaseImageLayerFuturesFuture, buildAndPushContainerConfigurationFutureFuture}).call((Callable)new PushImageStep(this.buildConfiguration, listeningExecutorService, (ListenableFuture<Authorization>)authenticatePushFuture, (ListenableFuture<List<ListenableFuture<CachedLayer>>>)pullBaseImageLayerFuturesFuture, (List<ListenableFuture<CachedLayer>>)buildAndCacheApplicationLayerFutures, (ListenableFuture<List<ListenableFuture<Void>>>)pushBaseImageLayerFuturesFuture, (List<ListenableFuture<Void>>)pushApplicationLayersFuture, (ListenableFuture<ListenableFuture<BlobDescriptor>>)buildAndPushContainerConfigurationFutureFuture), (Executor)listeningExecutorService);
                timer2.lap("Running push new image");
                pushImageFuture.get();
            }
        }
        this.buildConfiguration.getBuildLogger().info("");
        this.buildConfiguration.getBuildLogger().info("Container entrypoint set to " + entrypoint);
    }
}

