/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheReader;
import com.google.cloud.tools.jib.cache.CacheWriter;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class PullAndCacheBaseImageLayerStep
implements Callable<CachedLayer> {
    private static final String DESCRIPTION = "Pulling base image layer %s";
    private final BuildConfiguration buildConfiguration;
    private final Cache cache;
    private final DescriptorDigest layerDigest;
    private final Future<Authorization> pullAuthorizationFuture;

    PullAndCacheBaseImageLayerStep(BuildConfiguration buildConfiguration, Cache cache, DescriptorDigest layerDigest, Future<Authorization> pullAuthorizationFuture) {
        this.buildConfiguration = buildConfiguration;
        this.cache = cache;
        this.layerDigest = layerDigest;
        this.pullAuthorizationFuture = pullAuthorizationFuture;
    }

    @Override
    public CachedLayer call() throws IOException, RegistryException, LayerPropertyNotFoundException, ExecutionException, InterruptedException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.layerDigest));){
            RegistryClient registryClient = new RegistryClient(this.pullAuthorizationFuture.get(), this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository());
            CachedLayer cachedLayer = new CacheReader(this.cache).getLayer(this.layerDigest);
            if (cachedLayer != null) {
                CachedLayer cachedLayer2 = cachedLayer;
                return cachedLayer2;
            }
            CacheWriter cacheWriter = new CacheWriter(this.cache);
            CountingOutputStream layerOutputStream = cacheWriter.getLayerOutputStream(this.layerDigest);
            registryClient.pullBlob(this.layerDigest, (OutputStream)layerOutputStream);
            CachedLayer cachedLayer3 = cacheWriter.getCachedLayer(this.layerDigest, layerOutputStream);
            return cachedLayer3;
        }
    }
}

