/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.builder.PushBlobStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class PushLayersStep
implements Callable<List<ListenableFuture<Void>>> {
    private static final String DESCRIPTION = "Setting up to push layers";
    private final BuildConfiguration buildConfiguration;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Authorization> pushAuthorizationFuture;
    private final ListenableFuture<List<ListenableFuture<CachedLayer>>> cachedLayerFuturesFuture;

    PushLayersStep(BuildConfiguration buildConfiguration, ListeningExecutorService listeningExecutorService, ListenableFuture<Authorization> pushAuthorizationFuture, ListenableFuture<List<ListenableFuture<CachedLayer>>> cachedLayerFuturesFuture) {
        this.buildConfiguration = buildConfiguration;
        this.listeningExecutorService = listeningExecutorService;
        this.pushAuthorizationFuture = pushAuthorizationFuture;
        this.cachedLayerFuturesFuture = cachedLayerFuturesFuture;
    }

    @Override
    public List<ListenableFuture<Void>> call() throws ExecutionException, InterruptedException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            ArrayList<ListenableFuture> pushLayerFutures = new ArrayList<ListenableFuture>();
            for (ListenableFuture<CachedLayer> cachedLayerFuture : NonBlockingFutures.get(this.cachedLayerFuturesFuture)) {
                pushLayerFutures.add(Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{this.pushAuthorizationFuture, cachedLayerFuture}).call((Callable)new PushBlobStep(this.buildConfiguration, (Future<Authorization>)this.pushAuthorizationFuture, (Future<CachedLayer>)cachedLayerFuture), (Executor)this.listeningExecutorService));
            }
            ArrayList<ListenableFuture> arrayList = pushLayerFutures;
            return arrayList;
        }
    }
}

