/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements Callable<Authorization> {
    private static final String DESCRIPTION = "Retrieving registry credentials for %s";
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final BuildConfiguration buildConfiguration;
    private final String registry;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final DockerConfigCredentialRetriever dockerConfigCredentialRetriever;

    RetrieveRegistryCredentialsStep(BuildConfiguration buildConfiguration, String registry) {
        this(buildConfiguration, registry, new DockerCredentialHelperFactory(registry), new DockerConfigCredentialRetriever(registry));
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(BuildConfiguration buildConfiguration, String registry, DockerCredentialHelperFactory dockerCredentialHelperFactory, DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        this.buildConfiguration = buildConfiguration;
        this.registry = registry;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.dockerConfigCredentialRetriever = dockerConfigCredentialRetriever;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Authorization call() throws IOException, NonexistentDockerCredentialHelperException {
        block35: {
            block33: {
                block34: {
                    block31: {
                        block32: {
                            block29: {
                                block30: {
                                    ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format("Retrieving registry credentials for %s", new Object[]{this.buildConfiguration.getTargetRegistry()}));
                                    var2_2 = null;
                                    try {
                                        for (String var4_5 : this.buildConfiguration.getCredentialHelperNames()) {
                                            authorization = this.retrieveFromCredentialHelper(var4_5);
                                            if (authorization == null) continue;
                                            var6_15 = authorization;
                                            if (var2_2 == null) break block29;
                                            break block30;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var3_4) {
                                        var2_2 = var3_4;
                                        throw var3_4;
                                    }
                                    catch (Throwable var10_23) {
                                        throw var10_23;
                                    }
                                }
                                try {
                                    ignored.close();
                                    return var6_15;
                                }
                                catch (Throwable var7_19) {
                                    var2_2.addSuppressed(var7_19);
                                    return var6_15;
                                }
                            }
                            ignored.close();
                            return var6_15;
lbl-1000:
                            // 1 sources

                            {
                                credentialSource = this.buildConfiguration.getKnownRegistryCredentials().getCredentialSource(this.registry);
                                if (credentialSource == null) break block31;
                                this.logGotCredentialsFrom(credentialSource);
                                var4_6 = this.buildConfiguration.getKnownRegistryCredentials().getAuthorization(this.registry);
                                if (var2_2 == null) break block32;
                            }
                            try {
                                ignored.close();
                                return var4_6;
                            }
                            catch (Throwable authorization) {
                                var2_2.addSuppressed(authorization);
                                return var4_6;
                            }
                        }
                        ignored.close();
                        return var4_6;
                    }
                    var4_7 = this.dockerConfigCredentialRetriever.retrieve();
                    if (var4_7 == null) break block33;
                    this.buildConfiguration.getBuildLogger().info("Using credentials from Docker config for " + this.registry);
                    authorization = var4_7;
                    if (var2_2 == null) break block34;
                    try {
                        ignored.close();
                        return authorization;
                    }
                    catch (Throwable var6_16) {
                        var2_2.addSuppressed(var6_16);
                        return authorization;
                    }
                }
                ignored.close();
                return authorization;
            }
            ** try [egrp 6[TRYBLOCK] [10, 15 : 268->377)] { 
lbl58:
            // 1 sources

            break block35;
            catch (IOException var4_8) {
                this.buildConfiguration.getBuildLogger().info("Unable to parse Docker config");
            }
        }
        for (String registrySuffix : RetrieveRegistryCredentialsStep.COMMON_CREDENTIAL_HELPERS.keySet()) {
            if (!this.registry.endsWith(registrySuffix)) continue;
            try {
                commonCredentialHelper = (String)RetrieveRegistryCredentialsStep.COMMON_CREDENTIAL_HELPERS.get((Object)registrySuffix);
                if (commonCredentialHelper == null) {
                    throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
                }
                authorization = this.retrieveFromCredentialHelper(commonCredentialHelper);
                if (authorization == null) continue;
                return authorization;
            }
            catch (NonexistentDockerCredentialHelperException ex) {
                if (ex.getMessage() == null) continue;
                this.buildConfiguration.getBuildLogger().warn(ex.getMessage());
            }
        }
        this.buildConfiguration.getBuildLogger().info("No credentials could be retrieved for registry " + this.registry);
        return null;
lbl77:
        // 1 sources

        finally {
            if (var2_2 != null) {
                try {
                    ignored.close();
                }
                catch (Throwable var9_22) {
                    var2_2.addSuppressed(var9_22);
                }
            } else {
                ignored.close();
            }
        }
    }

    @Nullable
    @VisibleForTesting
    Authorization retrieveFromCredentialHelper(String credentialHelperSuffix) throws NonexistentDockerCredentialHelperException, IOException {
        this.buildConfiguration.getBuildLogger().info("Checking credentials from docker-credential-" + credentialHelperSuffix);
        try {
            Authorization authorization = this.dockerCredentialHelperFactory.withCredentialHelperSuffix(credentialHelperSuffix).retrieve();
            this.logGotCredentialsFrom("docker-credential-" + credentialHelperSuffix);
            return authorization;
        }
        catch (NonexistentServerUrlDockerCredentialHelperException ex) {
            this.buildConfiguration.getBuildLogger().info("No credentials for " + this.registry + " in docker-credential-" + credentialHelperSuffix);
            return null;
        }
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.buildConfiguration.getBuildLogger().info("Using " + credentialSource + " for " + this.registry);
    }
}

