/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.cloud.tools.jib.filesystem.PathConsumer;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class DirectoryWalker {
    private final Path rootDir;
    @Nullable
    private Predicate<? super Path> pathFilter;

    public DirectoryWalker(Path rootDir) throws NotDirectoryException {
        if (!Files.isDirectory(rootDir, new LinkOption[0])) {
            throw new NotDirectoryException(rootDir + " is not a directory");
        }
        this.rootDir = rootDir;
    }

    public DirectoryWalker filter(@Nullable Predicate<? super Path> pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public List<Path> walk(PathConsumer pathConsumer) throws IOException {
        List<Path> files = this.walk();
        for (Path path : files) {
            pathConsumer.accept(path);
        }
        return files;
    }

    public List<Path> walk() throws IOException {
        try (Stream<Path> fileStream = Files.walk(this.rootDir, new FileVisitOption[0]);){
            Stream<Path> filteredFileStream = fileStream;
            if (this.pathFilter != null) {
                filteredFileStream = fileStream.filter(this.pathFilter);
            }
            List<Path> list = filteredFileStream.collect(Collectors.toList());
            return list;
        }
    }
}

