/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class ImageLayers<T extends Layer>
implements Iterable<T> {
    private final List<T> layers = new ArrayList<T>();
    private final Set<DescriptorDigest> layerDigests = new HashSet<DescriptorDigest>();

    public List<T> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public int size() {
        return this.layers.size();
    }

    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    public T get(int index) {
        return (T)((Layer)this.layers.get(index));
    }

    @Nullable
    public T get(DescriptorDigest digest) throws LayerPropertyNotFoundException {
        if (!this.has(digest)) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getBlobDescriptor().getDigest().equals(digest)) continue;
            return (T)layer;
        }
        throw new IllegalStateException("Layer digest exists but layer not found");
    }

    public boolean has(DescriptorDigest digest) {
        return this.layerDigests.contains(digest);
    }

    public ImageLayers<T> add(T layer) throws LayerPropertyNotFoundException {
        if (!this.isSameAsLastLayer(layer)) {
            this.layerDigests.add(layer.getBlobDescriptor().getDigest());
            this.layers.add(layer);
        }
        return this;
    }

    public <U extends T> ImageLayers<T> addAll(ImageLayers<U> layers) throws LayerPropertyNotFoundException {
        for (Layer layer : layers) {
            this.add(layer);
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getLayers().iterator();
    }

    private boolean isSameAsLastLayer(T layer) throws LayerPropertyNotFoundException {
        if (this.layers.size() == 0) {
            return false;
        }
        Layer lastLayer = (Layer)Iterables.getLast(this.layers);
        return layer.getBlobDescriptor().getDigest().equals(lastLayer.getBlobDescriptor().getDigest());
    }
}

