/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import java.lang.reflect.InvocationTargetException;

public class ImageToJsonTranslator {
    private final Image image;

    public ImageToJsonTranslator(Image image) {
        this.image = image;
    }

    public Blob getContainerConfigurationBlob() throws LayerPropertyNotFoundException {
        ContainerConfigurationTemplate template = new ContainerConfigurationTemplate();
        for (Layer layer : this.image.getLayers()) {
            template.addLayerDiffId(layer.getDiffId());
        }
        template.setContainerEnvironment(this.image.getEnvironment());
        template.setContainerEntrypoint(this.image.getEntrypoint());
        return JsonTemplateMapper.toBlob(template);
    }

    public <T extends BuildableManifestTemplate> T getManifestTemplate(Class<T> manifestTemplateClass, BlobDescriptor containerConfigurationBlobDescriptor) throws LayerPropertyNotFoundException {
        try {
            BuildableManifestTemplate template = (BuildableManifestTemplate)manifestTemplateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DescriptorDigest containerConfigurationDigest = containerConfigurationBlobDescriptor.getDigest();
            long containerConfigurationSize = containerConfigurationBlobDescriptor.getSize();
            template.setContainerConfiguration(containerConfigurationSize, containerConfigurationDigest);
            for (Layer layer : this.image.getLayers()) {
                template.addLayer(layer.getBlobDescriptor().getSize(), layer.getBlobDescriptor().getDigest());
            }
            return (T)template;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException(manifestTemplateClass + " cannot be instantiated", ex);
        }
    }
}

