/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildImageSteps;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.OCIManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.ProjectProperties;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildImageMojo
extends AbstractMojo {
    private static final String CACHE_DIRECTORY_NAME = "jib-cache";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="gcr.io/distroless/java", required=true)
    private String from;
    @Parameter
    private String registry;
    @Parameter(required=true)
    private String repository;
    @Parameter
    private String tag;
    @Parameter
    private List<String> credHelpers;
    @Parameter
    private List<String> jvmFlags;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private String mainClass;
    @Parameter(defaultValue="true", required=true)
    private boolean enableReproducibleBuilds;
    @Parameter(defaultValue="Docker", required=true)
    private ImageFormat imageFormat;
    @Parameter(defaultValue="false", required=true)
    private boolean useOnlyProjectCache;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Authorization targetRegistryCredentials;
        this.validateParameters();
        ProjectProperties projectProperties = new ProjectProperties(this.project, this.getLog());
        if (this.mainClass == null) {
            this.mainClass = projectProperties.getMainClassFromMavenJarPlugin();
            if (this.mainClass == null) {
                this.throwMojoExecutionExceptionWithHelpMessage(new MojoFailureException("Could not find main class specified in maven-jar-plugin"), "add a `mainClass` configuration to jib-maven-plugin");
            }
        }
        SourceFilesConfiguration sourceFilesConfiguration = projectProperties.getSourceFilesConfiguration();
        ImageReference baseImage = this.getBaseImageReference();
        this.session.getSettings().getServer(baseImage.getRegistry());
        HashMap<String, Authorization> registryCredentials = new HashMap<String, Authorization>(2);
        Authorization baseImageRegistryCredentials = this.getRegistryCredentialsFromSettings(baseImage.getRegistry());
        if (baseImageRegistryCredentials != null) {
            registryCredentials.put(baseImage.getRegistry(), baseImageRegistryCredentials);
        }
        if ((targetRegistryCredentials = this.getRegistryCredentialsFromSettings(this.registry)) != null) {
            registryCredentials.put(this.registry, targetRegistryCredentials);
        }
        RegistryCredentials mavenSettingsCredentials = RegistryCredentials.from("Maven settings", registryCredentials);
        ImageReference targetImageReference = ImageReference.of(this.registry, this.repository, this.tag);
        BuildConfiguration buildConfiguration = BuildConfiguration.builder(new MavenBuildLogger(this.getLog())).setBaseImage(baseImage).setTargetImage(targetImageReference).setCredentialHelperNames(this.credHelpers).setKnownRegistryCredentials(mavenSettingsCredentials).setMainClass(this.mainClass).setEnableReproducibleBuilds(this.enableReproducibleBuilds).setJvmFlags(this.jvmFlags).setEnvironment(this.environment).setTargetFormat(this.imageFormat.getManifestTemplateClass()).build();
        Path cacheDirectory = Paths.get(this.project.getBuild().getDirectory(), CACHE_DIRECTORY_NAME);
        if (!Files.exists(cacheDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(cacheDirectory, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Could not create cache directory: " + cacheDirectory, (Exception)ex);
            }
        }
        Caches.Initializer cachesInitializer = Caches.newInitializer(cacheDirectory);
        if (this.useOnlyProjectCache) {
            cachesInitializer.setBaseCacheDirectory(cacheDirectory);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Pushing image as " + targetImageReference));
        this.getLog().info((CharSequence)"");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        this.buildImage(new BuildImageSteps(buildConfiguration, sourceFilesConfiguration, cachesInitializer));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Built and pushed image as " + targetImageReference));
        this.getLog().info((CharSequence)"");
    }

    @VisibleForTesting
    void buildImage(BuildImageSteps buildImageSteps) throws MojoExecutionException {
        try {
            buildImageSteps.run();
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            this.throwMojoExecutionExceptionWithHelpMessage(cacheMetadataCorruptedException, "run 'mvn clean' to clear the cache");
        }
        catch (ExecutionException executionException) {
            BuildConfiguration buildConfiguration = buildImageSteps.getBuildConfiguration();
            if (executionException.getCause() instanceof HttpHostConnectException) {
                this.throwMojoExecutionExceptionWithHelpMessage(executionException.getCause(), "make sure your Internet is up and that the registry you are pushing to exists");
            } else if (executionException.getCause() instanceof RegistryUnauthorizedException) {
                this.handleRegistryUnauthorizedException((RegistryUnauthorizedException)executionException.getCause(), buildConfiguration);
            } else if (executionException.getCause() instanceof RegistryAuthenticationFailedException && executionException.getCause().getCause() instanceof HttpResponseException) {
                this.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(buildConfiguration.getTargetRegistry(), buildConfiguration.getTargetRepository(), (HttpResponseException)executionException.getCause().getCause()), buildConfiguration);
            } else {
                this.throwMojoExecutionExceptionWithHelpMessage(executionException.getCause(), null);
            }
        }
        catch (IOException | InterruptedException ex) {
            this.getLog().error((Throwable)ex);
            this.throwMojoExecutionExceptionWithHelpMessage(ex, null);
        }
        catch (CacheDirectoryNotOwnedException ex) {
            this.throwMojoExecutionExceptionWithHelpMessage(ex, "check that '" + ex.getCacheDirectory() + "' is not used by another application or set the `useOnlyProjectCache` configuration");
        }
    }

    @Nullable
    private Authorization getRegistryCredentialsFromSettings(String registry) {
        Server registryServerSettings = this.session.getSettings().getServer(registry);
        if (registryServerSettings == null) {
            return null;
        }
        return Authorizations.withBasicCredentials(registryServerSettings.getUsername(), registryServerSettings.getPassword());
    }

    private void validateParameters() throws MojoFailureException {
        if (!Strings.isNullOrEmpty((String)this.registry) && !ImageReference.isValidRegistry(this.registry)) {
            this.getLog().error((CharSequence)"Invalid format for 'registry'");
        }
        if (!ImageReference.isValidRepository(this.repository)) {
            this.getLog().error((CharSequence)"Invalid format for 'repository'");
        }
        if (!Strings.isNullOrEmpty((String)this.tag)) {
            if (!ImageReference.isValidTag(this.tag)) {
                this.getLog().error((CharSequence)"Invalid format for 'tag'");
            }
            if (this.tag.indexOf(47) >= 0) {
                this.getLog().error((CharSequence)"'tag' cannot contain backslashes");
                throw new MojoFailureException("Invalid configuration parameters");
            }
        }
    }

    private ImageReference getBaseImageReference() throws MojoFailureException {
        try {
            return ImageReference.parse(this.from);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoFailureException("Parameter 'from' is invalid", (Throwable)ex);
        }
    }

    private void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, BuildConfiguration buildConfiguration) throws MojoExecutionException {
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "make sure your have permissions for " + registryUnauthorizedException.getImageReference());
        } else if (!(buildConfiguration.getCredentialHelperNames() != null && !buildConfiguration.getCredentialHelperNames().isEmpty() || buildConfiguration.getKnownRegistryCredentials() != null && buildConfiguration.getKnownRegistryCredentials().has(registryUnauthorizedException.getRegistry()))) {
            this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "set a credential helper name with the configuration 'credHelpers' or set credentials for '" + registryUnauthorizedException.getRegistry() + "' in your Maven settings");
        } else {
            this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "make sure your credentials for '" + registryUnauthorizedException.getRegistry() + "' are set up correctly");
        }
    }

    private <T extends Throwable> void throwMojoExecutionExceptionWithHelpMessage(T ex, @Nullable String suggestion) throws MojoExecutionException {
        StringBuilder message = new StringBuilder("Build image failed");
        if (suggestion != null) {
            message.append(", perhaps you should ");
            message.append(suggestion);
        }
        throw new MojoExecutionException(message.toString(), ex);
    }

    public static enum ImageFormat {
        Docker(V22ManifestTemplate.class),
        OCI(OCIManifestTemplate.class);

        private final Class<? extends BuildableManifestTemplate> manifestTemplateClass;

        private ImageFormat(Class<? extends BuildableManifestTemplate> manifestTemplateClass) {
            this.manifestTemplateClass = manifestTemplateClass;
        }

        private Class<? extends BuildableManifestTemplate> getManifestTemplateClass() {
            return this.manifestTemplateClass;
        }
    }
}

