/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.EntrypointBuilder;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.filesystem.PathConsumer;
import com.google.cloud.tools.jib.maven.ProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.InsecureRecursiveDeleteException;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dockercontext", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class DockerContextMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="jib.dockerDir", defaultValue="${project.build.directory}/jib-dockercontext", required=true)
    private String targetDir;
    @Parameter(defaultValue="gcr.io/distroless/java", required=true)
    private String from;
    @Parameter
    private List<String> jvmFlags = Collections.emptyList();
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private String mainClass;

    @VisibleForTesting
    static void copyFiles(List<Path> sourceFiles, Path destDir) throws IOException {
        for (Path sourceFile : sourceFiles) {
            PathConsumer copyPathConsumer = path -> {
                Path destPath = destDir.resolve(sourceFile.getParent().relativize(path));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectory(destPath, new FileAttribute[0]);
                } else {
                    Files.copy(path, destPath, new CopyOption[0]);
                }
            };
            if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                new DirectoryWalker(sourceFile).walk(copyPathConsumer);
                continue;
            }
            copyPathConsumer.accept(sourceFile);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectProperties projectProperties = new ProjectProperties(this.project, this.getLog());
        if (this.mainClass == null) {
            this.mainClass = projectProperties.getMainClassFromMavenJarPlugin();
            if (this.mainClass == null) {
                this.throwMojoExecutionExceptionWithHelpMessage(new MojoFailureException("Could not find main class specified in maven-jar-plugin"), "add a `mainClass` configuration to jib-maven-plugin");
            }
        }
        this.createDockerContext(projectProperties);
    }

    @VisibleForTesting
    DockerContextMojo setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
        return this;
    }

    @VisibleForTesting
    DockerContextMojo setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    @VisibleForTesting
    DockerContextMojo setTargetDir(String targetDir) {
        this.targetDir = targetDir;
        return this;
    }

    @VisibleForTesting
    DockerContextMojo setFrom(String baseImage) {
        this.from = baseImage;
        return this;
    }

    @VisibleForTesting
    String makeDockerfile(SourceFilesConfiguration sourceFilesConfiguration) throws IOException {
        String dockerfileTemplate = Resources.toString((URL)Resources.getResource((String)"DockerfileTemplate"), (Charset)StandardCharsets.UTF_8);
        return dockerfileTemplate.replace("@@BASE_IMAGE@@", this.from).replace("@@DEPENDENCIES_PATH_ON_IMAGE@@", sourceFilesConfiguration.getDependenciesPathOnImage()).replace("@@RESOURCES_PATH_ON_IMAGE@@", sourceFilesConfiguration.getResourcesPathOnImage()).replace("@@CLASSES_PATH_ON_IMAGE@@", sourceFilesConfiguration.getClassesPathOnImage()).replace("@@ENTRYPOINT@@", this.getEntrypoint(sourceFilesConfiguration));
    }

    @VisibleForTesting
    String getEntrypoint(SourceFilesConfiguration sourceFilesConfiguration) {
        List<String> entrypoint = EntrypointBuilder.makeEntrypoint(sourceFilesConfiguration, this.jvmFlags, this.mainClass);
        StringBuilder entrypointString = new StringBuilder("[");
        boolean firstComponent = true;
        for (String entrypointComponent : entrypoint) {
            if (!firstComponent) {
                entrypointString.append(',');
            }
            entrypointComponent = entrypointComponent.replaceAll("\"", Matcher.quoteReplacement("\\\""));
            entrypointString.append('\"').append(entrypointComponent).append('\"');
            firstComponent = false;
        }
        entrypointString.append(']');
        return entrypointString.toString();
    }

    private void createDockerContext(ProjectProperties projectProperties) throws MojoExecutionException, MojoFailureException {
        SourceFilesConfiguration sourceFilesConfiguration = projectProperties.getSourceFilesConfiguration();
        try {
            Path targetDirPath = Paths.get(this.targetDir, new String[0]);
            if (Files.exists(targetDirPath, new LinkOption[0])) {
                MoreFiles.deleteDirectoryContents((Path)targetDirPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            }
            Files.createDirectory(targetDirPath, new FileAttribute[0]);
            Path dependenciesDir = targetDirPath.resolve("libs");
            Path resourcesDIr = targetDirPath.resolve("resources");
            Path classesDir = targetDirPath.resolve("classes");
            Files.createDirectory(dependenciesDir, new FileAttribute[0]);
            Files.createDirectory(resourcesDIr, new FileAttribute[0]);
            Files.createDirectory(classesDir, new FileAttribute[0]);
            DockerContextMojo.copyFiles(sourceFilesConfiguration.getDependenciesFiles(), dependenciesDir);
            DockerContextMojo.copyFiles(sourceFilesConfiguration.getResourcesFiles(), resourcesDIr);
            DockerContextMojo.copyFiles(sourceFilesConfiguration.getClassesFiles(), classesDir);
            Files.write(targetDirPath.resolve("Dockerfile"), this.makeDockerfile(sourceFilesConfiguration).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            projectProperties.getLog().info((CharSequence)("Created Docker context at " + this.targetDir));
        }
        catch (InsecureRecursiveDeleteException ex) {
            this.throwMojoExecutionExceptionWithHelpMessage(ex, "cannot clear directory '" + this.targetDir + "' safely - clear it manually before creating the Docker context");
        }
        catch (IOException ex) {
            this.throwMojoExecutionExceptionWithHelpMessage(ex, "check if `targetDir` is set correctly");
        }
    }

    private <T extends Throwable> void throwMojoExecutionExceptionWithHelpMessage(T ex, @Nullable String suggestion) throws MojoExecutionException {
        StringBuilder message = new StringBuilder("Export Docker context failed");
        if (suggestion != null) {
            message.append(", perhaps you should ");
            message.append(suggestion);
        }
        throw new MojoExecutionException(message.toString(), ex);
    }
}

