/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.maven.MavenSourceFilesConfiguration;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class ProjectProperties {
    private final MavenProject project;
    private final Log log;

    ProjectProperties(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    SourceFilesConfiguration getSourceFilesConfiguration() throws MojoExecutionException {
        try {
            MavenSourceFilesConfiguration sourceFilesConfiguration = MavenSourceFilesConfiguration.getForProject(this.project);
            this.log.info((CharSequence)"");
            this.log.info((CharSequence)"Containerizing application with the following files:");
            this.log.info((CharSequence)"");
            this.log.info((CharSequence)"\tDependencies:");
            this.log.info((CharSequence)"");
            sourceFilesConfiguration.getDependenciesFiles().forEach(dependencyFile -> this.log.info((CharSequence)("\t\t" + dependencyFile)));
            this.log.info((CharSequence)"\tResources:");
            this.log.info((CharSequence)"");
            sourceFilesConfiguration.getResourcesFiles().forEach(resourceFile -> this.log.info((CharSequence)("\t\t" + resourceFile)));
            this.log.info((CharSequence)"\tClasses:");
            this.log.info((CharSequence)"");
            sourceFilesConfiguration.getClassesFiles().forEach(classesFile -> this.log.info((CharSequence)("\t\t" + classesFile)));
            this.log.info((CharSequence)"");
            return sourceFilesConfiguration;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed", (Exception)ex);
        }
    }

    @Nullable
    String getMainClassFromMavenJarPlugin() {
        String mainClass;
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null && (mainClass = this.getMainClassFromMavenJarPlugin(mavenJarPlugin)) != null) {
            this.log.info((CharSequence)("Using main class from maven-jar-plugin: " + mainClass));
            return mainClass;
        }
        return null;
    }

    @Nullable
    private String getMainClassFromMavenJarPlugin(Plugin mavenJarPlugin) {
        Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
        if (jarConfiguration == null) {
            return null;
        }
        Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
        if (archiveObject == null) {
            return null;
        }
        Xpp3Dom manifestObject = archiveObject.getChild("manifest");
        if (manifestObject == null) {
            return null;
        }
        Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
        if (mainClassObject == null) {
            return null;
        }
        return mainClassObject.getValue();
    }

    Log getLog() {
        return this.log;
    }
}

