/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RegistryCredentials {
    private static final RegistryCredentials EMPTY = new RegistryCredentials();
    private final Map<String, AuthorizationSourcePair> credentials = new HashMap<String, AuthorizationSourcePair>();

    public static RegistryCredentials none() {
        return EMPTY;
    }

    public static RegistryCredentials of(String registry, String credentialSource, Authorization authorization) {
        return new RegistryCredentials().store(registry, credentialSource, authorization);
    }

    public static RegistryCredentials from(List<String> credentialHelperSuffixes, List<String> registries) throws IOException, NonexistentDockerCredentialHelperException {
        RegistryCredentials registryCredentials = new RegistryCredentials();
        for (String registry : registries) {
            for (String credentialHelperSuffix : credentialHelperSuffixes) {
                try {
                    registryCredentials.store(registry, "docker-credential-" + credentialHelperSuffix, new DockerCredentialHelper(registry, credentialHelperSuffix).retrieve());
                }
                catch (NonexistentServerUrlDockerCredentialHelperException nonexistentServerUrlDockerCredentialHelperException) {}
            }
        }
        return registryCredentials;
    }

    public static RegistryCredentials from(String credentialSource, Map<String, Authorization> registryCredentialMap) {
        RegistryCredentials registryCredentials = new RegistryCredentials();
        for (Map.Entry<String, Authorization> registryCredential : registryCredentialMap.entrySet()) {
            registryCredentials.store(registryCredential.getKey(), credentialSource, registryCredential.getValue());
        }
        return registryCredentials;
    }

    private RegistryCredentials() {
    }

    public boolean has(String registry) {
        return this.credentials.containsKey(registry);
    }

    @Nullable
    public Authorization getAuthorization(String registry) {
        if (this.credentials.get(registry) == null) {
            return null;
        }
        return this.credentials.get(registry).authorization;
    }

    @Nullable
    public String getCredentialSource(String registry) {
        if (this.credentials.get(registry) == null) {
            return null;
        }
        return this.credentials.get(registry).credentialSource;
    }

    private RegistryCredentials store(String registry, String credentialSource, Authorization authorization) {
        this.credentials.put(registry, new AuthorizationSourcePair(credentialSource, authorization));
        return this;
    }

    private static class AuthorizationSourcePair {
        private final String credentialSource;
        private final Authorization authorization;

        private AuthorizationSourcePair(String credentialSource, Authorization authorization) {
            this.credentialSource = credentialSource;
            this.authorization = authorization;
        }
    }
}

