/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheReader;
import com.google.cloud.tools.jib.cache.CacheWriter;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.io.CountingOutputStream;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class PullAndCacheBaseImageLayerStep
implements AsyncStep<CachedLayer>,
Callable<CachedLayer> {
    private static final String DESCRIPTION = "Pulling base image layer %s";
    private final BuildConfiguration buildConfiguration;
    private final Cache cache;
    private final DescriptorDigest layerDigest;
    @Nullable
    private final Authorization pullAuthorization;
    private final ListenableFuture<CachedLayer> listenableFuture;

    PullAndCacheBaseImageLayerStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, Cache cache, DescriptorDigest layerDigest, @Nullable Authorization pullAuthorization) {
        this.buildConfiguration = buildConfiguration;
        this.cache = cache;
        this.layerDigest = layerDigest;
        this.pullAuthorization = pullAuthorization;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<CachedLayer> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public CachedLayer call() throws IOException, RegistryException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.layerDigest));){
            RegistryClient registryClient = this.buildConfiguration.newBaseImageRegistryClientFactory().setAuthorization(this.pullAuthorization).newRegistryClient();
            CachedLayer cachedLayer = new CacheReader(this.cache).getLayer(this.layerDigest);
            if (cachedLayer != null) {
                CachedLayer cachedLayer2 = cachedLayer;
                return cachedLayer2;
            }
            CacheWriter cacheWriter = new CacheWriter(this.cache);
            CountingOutputStream layerOutputStream = cacheWriter.getLayerOutputStream(this.layerDigest);
            registryClient.pullBlob(this.layerDigest, (OutputStream)layerOutputStream);
            layerOutputStream.close();
            CachedLayer cachedLayer3 = cacheWriter.getCachedLayer(layerOutputStream.getCount(), this.layerDigest);
            return cachedLayer3;
        }
    }
}

