/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Layer;
import java.nio.file.Path;

public class CachedLayer
implements Layer {
    private final Path contentFile;
    private final BlobDescriptor blobDescriptor;
    private final DescriptorDigest diffId;

    public CachedLayer(Path contentFile, BlobDescriptor blobDescriptor, DescriptorDigest diffId) {
        this.contentFile = contentFile;
        this.blobDescriptor = blobDescriptor;
        this.diffId = diffId;
    }

    public Path getContentFile() {
        return this.contentFile;
    }

    @Override
    public Blob getBlob() {
        return Blobs.from(this.contentFile);
    }

    @Override
    public BlobDescriptor getBlobDescriptor() {
        return this.blobDescriptor;
    }

    @Override
    public DescriptorDigest getDiffId() {
        return this.diffId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CachedLayer)) {
            return false;
        }
        CachedLayer otherLayer = (CachedLayer)other;
        return this.getBlobDescriptor().getDigest().equals(otherLayer.getBlobDescriptor().getDigest());
    }

    public int hashCode() {
        return this.getBlobDescriptor().getDigest().hashCode();
    }
}

