/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import java.nio.file.Path;
import java.util.Objects;

public class LayerEntry {
    private final Path sourceFile;
    private final AbsoluteUnixPath extractionPath;

    public LayerEntry(Path sourceFile, AbsoluteUnixPath extractionPath) {
        this.sourceFile = sourceFile;
        this.extractionPath = extractionPath;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public AbsoluteUnixPath getExtractionPath() {
        return this.extractionPath;
    }

    public String getAbsoluteSourceFileString() {
        return AbsoluteUnixPath.fromPath(this.sourceFile.toAbsolutePath()).toString();
    }

    public String getAbsoluteExtractionPathString() {
        return this.extractionPath.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayerEntry)) {
            return false;
        }
        LayerEntry otherLayerEntry = (LayerEntry)other;
        return this.sourceFile.equals(otherLayerEntry.sourceFile) && this.extractionPath.equals(otherLayerEntry.extractionPath);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.extractionPath);
    }
}

