/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.json.JsonTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class JsonTemplateMapper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T extends JsonTemplate> T readJsonFromFile(Path jsonFile, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(Files.newInputStream(jsonFile, new OpenOption[0]), templateClass));
    }

    public static <T extends JsonTemplate> T readJsonFromFileWithLock(Path jsonFile, Class<T> templateClass) throws IOException {
        FileChannel channel = FileChannel.open(jsonFile, StandardOpenOption.READ);
        channel.lock(0L, Long.MAX_VALUE, true);
        try (InputStream inputStream = Channels.newInputStream(channel);){
            JsonTemplate jsonTemplate = (JsonTemplate)objectMapper.readValue(inputStream, templateClass);
            return (T)jsonTemplate;
        }
    }

    public static <T extends JsonTemplate> T readJson(String jsonString, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(jsonString, templateClass));
    }

    public static <T extends JsonTemplate> List<T> readListOfJson(String jsonString, Class<T> templateClass) throws IOException {
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, templateClass);
        return (List)objectMapper.readValue(jsonString, (JavaType)listType);
    }

    public static Blob toBlob(JsonTemplate template) {
        return JsonTemplateMapper.toBlob((Object)template);
    }

    public static Blob toBlob(List<? extends JsonTemplate> templates) {
        return JsonTemplateMapper.toBlob(templates);
    }

    private static Blob toBlob(Object template) {
        return Blobs.from(outputStream -> objectMapper.writeValue(outputStream, template));
    }

    private JsonTemplateMapper() {
    }
}

