/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenLayerConfigurations {
    static JavaLayerConfigurations getForProject(MavenProject project, Path extraDirectory, AbsoluteUnixPath appRoot) throws IOException {
        Path classesSourceDirectory = Paths.get(project.getBuild().getSourceDirectory(), new String[0]);
        Path classesOutputDirectory = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        ArrayList<Path> dependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> snapshotDependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> resourcesFiles = new ArrayList<Path>();
        ArrayList<Path> classesFiles = new ArrayList<Path>();
        ArrayList<Path> extraFiles = new ArrayList();
        for (Artifact artifact : project.getArtifacts()) {
            if (artifact.isSnapshot()) {
                snapshotDependenciesFiles.add(artifact.getFile().toPath());
                continue;
            }
            dependenciesFiles.add(artifact.getFile().toPath());
        }
        try (Stream<Path> classFileStream = Files.list(classesOutputDirectory);){
            classFileStream.forEach(classFile -> {
                if (Files.isDirectory(classFile, new LinkOption[0]) && Files.exists(classesSourceDirectory.resolve(classesOutputDirectory.relativize((Path)classFile)), new LinkOption[0])) {
                    classesFiles.add((Path)classFile);
                    return;
                }
                if (FileSystems.getDefault().getPathMatcher("glob:**.class").matches((Path)classFile)) {
                    classesFiles.add((Path)classFile);
                    return;
                }
                resourcesFiles.add((Path)classFile);
            });
        }
        if (Files.exists(extraDirectory, new LinkOption[0])) {
            try {
                var11_12 = null;
                try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(extraDirectory);){
                    extraFiles = extraFilesLayerDirectoryFiles.collect(Collectors.toList());
                }
                catch (Throwable throwable) {
                    var11_12 = throwable;
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw new IOException("Failed to list directory for extra files: " + extraDirectory, ex);
            }
        }
        Collections.sort(dependenciesFiles);
        Collections.sort(snapshotDependenciesFiles);
        Collections.sort(resourcesFiles);
        Collections.sort(classesFiles);
        Collections.sort(extraFiles);
        return JavaLayerConfigurations.builder().setDependencyFiles(dependenciesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE)).setSnapshotDependencyFiles(snapshotDependenciesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE)).setResourceFiles(resourcesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE)).setClassFiles(classesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE)).setExtraFiles(extraFiles, AbsoluteUnixPath.get("/")).build();
    }

    private MavenLayerConfigurations() {
    }
}

