/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.event.DefaultEventEmitter;
import com.google.cloud.tools.jib.event.EventEmitter;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.event.JibEventType;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.LogEventHandler;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.cloud.tools.jib.maven.MavenLayerConfigurations;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.MainClassResolver;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectProperties
implements ProjectProperties {
    public static final String PLUGIN_NAME = "jib-maven-plugin";
    public static final String PLUGIN_KEY = "com.google.cloud.tools:jib-maven-plugin";
    static final String TOOL_NAME = "jib-maven-plugin";
    private static final String JAR_PLUGIN_NAME = "'maven-jar-plugin'";
    private final MavenProject project;
    private final EventEmitter eventEmitter;
    private final MavenJibLogger mavenJibLogger;
    private final JavaLayerConfigurations javaLayerConfigurations;

    static MavenProjectProperties getForProject(MavenProject project, Log log, Path extraDirectory, AbsoluteUnixPath appRoot) throws MojoExecutionException {
        try {
            return new MavenProjectProperties(project, MavenProjectProperties.makeEventEmitter(log), new MavenJibLogger(log), MavenLayerConfigurations.getForProject(project, extraDirectory, appRoot));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed; make sure you have compiled your project before trying to build the image. (Did you accidentally run \"mvn clean jib:build\" instead of \"mvn clean compile jib:build\"?)", (Exception)ex);
        }
    }

    private static EventEmitter makeEventEmitter(Log log) {
        return new DefaultEventEmitter(new EventHandlers().add(JibEventType.LOGGING, new LogEventHandler(log)).add(JibEventType.TIMING, new TimerEventHandler(arg_0 -> ((Log)log).debug(arg_0))));
    }

    @VisibleForTesting
    MavenProjectProperties(MavenProject project, EventEmitter eventEmitter, MavenJibLogger mavenJibLogger, JavaLayerConfigurations javaLayerConfigurations) {
        this.project = project;
        this.eventEmitter = eventEmitter;
        this.mavenJibLogger = mavenJibLogger;
        this.javaLayerConfigurations = javaLayerConfigurations;
    }

    @Override
    public JavaLayerConfigurations getJavaLayerConfigurations() {
        return this.javaLayerConfigurations;
    }

    @Override
    public EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }

    @Override
    public JibLogger getLogger() {
        return this.mavenJibLogger;
    }

    @Override
    public String getPluginName() {
        return "jib-maven-plugin";
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null) {
            Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
            if (jarConfiguration == null) {
                return null;
            }
            Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
            if (archiveObject == null) {
                return null;
            }
            Xpp3Dom manifestObject = archiveObject.getChild("manifest");
            if (manifestObject == null) {
                return null;
            }
            Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
            if (mainClassObject == null) {
                return null;
            }
            return mainClassObject.getValue();
        }
        return null;
    }

    @Override
    public Path getCacheDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), "jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        return false;
    }

    String getMainClass(JibPluginConfiguration jibPluginConfiguration) throws MojoExecutionException {
        try {
            return MainClassResolver.resolveMainClass(jibPluginConfiguration.getMainClass(), this);
        }
        catch (MainClassInferenceException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

