/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nullable;

public class ConfigurationPropertyValidator {
    public static Optional<Credential> getImageCredential(JibLogger logger, String usernameProperty, String passwordProperty, AuthProperty auth) {
        String commandlineUsername = System.getProperty(usernameProperty);
        String commandlinePassword = System.getProperty(passwordProperty);
        if (!Strings.isNullOrEmpty((String)commandlineUsername) && !Strings.isNullOrEmpty((String)commandlinePassword)) {
            return Optional.of(Credential.basic(commandlineUsername, commandlinePassword));
        }
        if (!Strings.isNullOrEmpty((String)commandlinePassword) && Strings.isNullOrEmpty((String)commandlineUsername)) {
            logger.warn(passwordProperty + " system property is set, but " + usernameProperty + " is not; attempting other authentication methods.");
        }
        if (!Strings.isNullOrEmpty((String)commandlineUsername) && Strings.isNullOrEmpty((String)commandlinePassword)) {
            logger.warn(usernameProperty + " system property is set, but " + passwordProperty + " is not; attempting other authentication methods.");
        }
        if (Strings.isNullOrEmpty((String)auth.getUsername()) && Strings.isNullOrEmpty((String)auth.getPassword())) {
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)auth.getUsername())) {
            logger.warn(auth.getUsernamePropertyDescriptor() + " is missing from build configuration; ignoring auth section.");
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)auth.getPassword())) {
            logger.warn(auth.getPasswordPropertyDescriptor() + " is missing from build configuration; ignoring auth section.");
            return Optional.empty();
        }
        return Optional.of(Credential.basic(auth.getUsername(), auth.getPassword()));
    }

    public static ImageReference getGeneratedTargetDockerTag(@Nullable String targetImage, JibLogger logger, String projectName, String projectVersion, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException {
        if (Strings.isNullOrEmpty((String)targetImage)) {
            logger.lifecycle(helpfulSuggestions.forGeneratedTag(projectName, projectVersion));
            ImageReference.parse(projectName + ":" + projectVersion);
            return ImageReference.of(null, projectName, projectVersion);
        }
        return ImageReference.parse(targetImage);
    }

    private ConfigurationPropertyValidator() {
    }
}

