/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.TargetImage;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DockerDaemonImage
implements TargetImage {
    private final ImageReference imageReference;
    private Path dockerExecutable = Paths.get("docker", new String[0]);

    public static DockerDaemonImage named(ImageReference imageReference) {
        return new DockerDaemonImage(imageReference);
    }

    public static DockerDaemonImage named(String imageReference) throws InvalidImageReferenceException {
        return DockerDaemonImage.named(ImageReference.parse(imageReference));
    }

    private DockerDaemonImage(ImageReference imageReference) {
        this.imageReference = imageReference;
    }

    public DockerDaemonImage setDockerExecutable(Path dockerExecutable) {
        this.dockerExecutable = dockerExecutable;
        return this;
    }

    ImageReference getImageReference() {
        return this.imageReference;
    }

    Path getDockerExecutable() {
        return this.dockerExecutable;
    }
}

