/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Image<T extends Layer> {
    @Nullable
    private final Instant created;
    private final ImageLayers<T> layers;
    private final ImmutableList<HistoryEntry> history;
    @Nullable
    private final ImmutableMap<String, String> environment;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> javaArguments;
    @Nullable
    private final ImmutableList<Port> exposedPorts;
    @Nullable
    private final ImmutableMap<String, String> labels;
    @Nullable
    private final String workingDirectory;

    public static <T extends Layer> Builder<T> builder() {
        return new Builder();
    }

    private Image(@Nullable Instant created, ImageLayers<T> layers, ImmutableList<HistoryEntry> history, @Nullable ImmutableMap<String, String> environment, @Nullable ImmutableList<String> entrypoint, @Nullable ImmutableList<String> javaArguments, @Nullable ImmutableList<Port> exposedPorts, @Nullable ImmutableMap<String, String> labels, @Nullable String workingDirectory) {
        this.created = created;
        this.layers = layers;
        this.history = history;
        this.environment = environment;
        this.entrypoint = entrypoint;
        this.javaArguments = javaArguments;
        this.exposedPorts = exposedPorts;
        this.labels = labels;
        this.workingDirectory = workingDirectory;
    }

    @Nullable
    public Instant getCreated() {
        return this.created;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    @Nullable
    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    @Nullable
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ImmutableList<T> getLayers() {
        return this.layers.getLayers();
    }

    public ImmutableList<HistoryEntry> getHistory() {
        return this.history;
    }

    public static class Builder<T extends Layer> {
        private final ImageLayers.Builder<T> imageLayersBuilder = ImageLayers.builder();
        private final ImmutableList.Builder<HistoryEntry> historyBuilder = ImmutableList.builder();
        private final ImmutableMap.Builder<String, String> environmentBuilder = ImmutableMap.builder();
        private final ImmutableMap.Builder<String, String> labelsBuilder = ImmutableMap.builder();
        @Nullable
        private Instant created;
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> javaArguments;
        @Nullable
        private ImmutableList<Port> exposedPorts;
        @Nullable
        private String workingDirectory;

        public Builder<T> setCreated(Instant created) {
            this.created = created;
            return this;
        }

        public Builder<T> addEnvironment(@Nullable Map<String, String> environment) {
            if (environment != null) {
                this.environmentBuilder.putAll(environment);
            }
            return this;
        }

        public Builder<T> addEnvironmentVariable(String name, String value) {
            this.environmentBuilder.put((Object)name, (Object)value);
            return this;
        }

        public Builder<T> setEntrypoint(@Nullable List<String> entrypoint) {
            this.entrypoint = entrypoint == null ? null : ImmutableList.copyOf(entrypoint);
            return this;
        }

        public Builder<T> setJavaArguments(@Nullable List<String> javaArguments) {
            this.javaArguments = javaArguments == null ? null : ImmutableList.copyOf(javaArguments);
            return this;
        }

        public Builder<T> setExposedPorts(@Nullable List<Port> exposedPorts) {
            this.exposedPorts = exposedPorts == null ? null : ImmutableList.copyOf(exposedPorts);
            return this;
        }

        public Builder<T> addLabels(@Nullable Map<String, String> labels) {
            if (labels != null) {
                this.labelsBuilder.putAll(labels);
            }
            return this;
        }

        public Builder<T> addLabel(String name, String value) {
            this.labelsBuilder.put((Object)name, (Object)value);
            return this;
        }

        public Builder<T> setWorkingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder<T> addLayer(T layer) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add(layer);
            return this;
        }

        public Builder<T> addHistory(HistoryEntry history) {
            this.historyBuilder.add((Object)history);
            return this;
        }

        public Image<T> build() {
            return new Image(this.created, this.imageLayersBuilder.build(), this.historyBuilder.build(), this.environmentBuilder.build(), this.entrypoint, this.javaArguments, this.exposedPorts, this.labelsBuilder.build(), this.workingDirectory);
        }
    }
}

