/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.DefaultCredentialRetrievers;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;

class PluginConfigurationProcessor {
    private final BuildConfiguration.Builder buildConfigurationBuilder;
    private final ImageConfiguration.Builder baseImageConfigurationBuilder;
    private final ContainerConfiguration.Builder containerConfigurationBuilder;
    private final MavenSettingsServerCredentials mavenSettingsServerCredentials;
    private final boolean isBaseImageCredentialPresent;

    static AbsoluteUnixPath getAppRootChecked(JibPluginConfiguration jibPluginConfiguration) throws MojoExecutionException {
        String appRoot = jibPluginConfiguration.getAppRoot();
        try {
            return AbsoluteUnixPath.get(appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + appRoot);
        }
    }

    static PluginConfigurationProcessor processCommonConfiguration(MavenJibLogger logger, JibPluginConfiguration jibPluginConfiguration, MavenProjectProperties projectProperties) throws MojoExecutionException {
        jibPluginConfiguration.handleDeprecatedParameters(logger);
        try {
            JibSystemProperties.checkHttpTimeoutProperty();
        }
        catch (NumberFormatException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        MavenJibLogger.disableHttpLogging();
        ImageReference baseImage = PluginConfigurationProcessor.parseImageReference(jibPluginConfiguration.getBaseImage(), "from");
        if (JibSystemProperties.isSendCredentialsOverHttpEnabled()) {
            logger.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!");
        }
        MavenSettingsServerCredentials mavenSettingsServerCredentials = new MavenSettingsServerCredentials(((MavenSession)Preconditions.checkNotNull((Object)jibPluginConfiguration.getSession())).getSettings(), jibPluginConfiguration.getSettingsDecrypter(), logger);
        DefaultCredentialRetrievers defaultCredentialRetrievers = DefaultCredentialRetrievers.init(CredentialRetrieverFactory.forImage(baseImage, logger));
        Optional<Credential> optionalFromCredential = ConfigurationPropertyValidator.getImageCredential(logger, "jib.from.auth.username", "jib.from.auth.password", jibPluginConfiguration.getBaseImageAuth());
        if (optionalFromCredential.isPresent()) {
            defaultCredentialRetrievers.setKnownCredential(optionalFromCredential.get(), "jib-maven-plugin <from><auth> configuration");
        } else {
            optionalFromCredential = mavenSettingsServerCredentials.retrieve(baseImage.getRegistry());
            optionalFromCredential.ifPresent(fromCredential -> defaultCredentialRetrievers.setInferredCredential((Credential)fromCredential, "Maven settings"));
        }
        defaultCredentialRetrievers.setCredentialHelperSuffix(jibPluginConfiguration.getBaseImageCredentialHelperName());
        ImageConfiguration.Builder baseImageConfiguration = ImageConfiguration.builder(baseImage).setCredentialRetrievers(defaultCredentialRetrievers.asList());
        List<String> entrypoint = jibPluginConfiguration.getEntrypoint();
        if (entrypoint.isEmpty()) {
            String mainClass = projectProperties.getMainClass(jibPluginConfiguration);
            entrypoint = JavaEntrypointConstructor.makeDefaultEntrypoint(PluginConfigurationProcessor.getAppRootChecked(jibPluginConfiguration), jibPluginConfiguration.getJvmFlags(), mainClass);
        } else if (jibPluginConfiguration.getMainClass() != null || !jibPluginConfiguration.getJvmFlags().isEmpty()) {
            logger.warn("<mainClass> and <jvmFlags> are ignored when <entrypoint> is specified");
        }
        ContainerConfiguration.Builder containerConfigurationBuilder = ContainerConfiguration.builder().setEntrypoint(entrypoint).setProgramArguments(jibPluginConfiguration.getArgs()).setEnvironment(jibPluginConfiguration.getEnvironment()).setExposedPorts((List<Port>)ExposedPortsParser.parse(jibPluginConfiguration.getExposedPorts())).setLabels(jibPluginConfiguration.getLabels());
        if (jibPluginConfiguration.getUseCurrentTimestamp()) {
            logger.warn("Setting image creation time to current time; your image may not be reproducible.");
            containerConfigurationBuilder.setCreationTime(Instant.now());
        }
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(logger).setToolName("jib-maven-plugin").setEventEmitter(projectProperties.getEventEmitter()).setAllowInsecureRegistries(jibPluginConfiguration.getAllowInsecureRegistries()).setLayerConfigurations((List<LayerConfiguration>)projectProperties.getJavaLayerConfigurations().getLayerConfigurations());
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(projectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (jibPluginConfiguration.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        return new PluginConfigurationProcessor(buildConfigurationBuilder, baseImageConfiguration, containerConfigurationBuilder, mavenSettingsServerCredentials, optionalFromCredential.isPresent());
    }

    static ImageReference parseImageReference(String image, String type) {
        try {
            return ImageReference.parse(image);
        }
        catch (InvalidImageReferenceException ex) {
            throw new IllegalStateException("Parameter '" + type + "' is invalid", ex);
        }
    }

    private PluginConfigurationProcessor(BuildConfiguration.Builder buildConfigurationBuilder, ImageConfiguration.Builder baseImageConfigurationBuilder, ContainerConfiguration.Builder containerConfigurationBuilder, MavenSettingsServerCredentials mavenSettingsServerCredentials, boolean isBaseImageCredentialPresent) {
        this.buildConfigurationBuilder = buildConfigurationBuilder;
        this.baseImageConfigurationBuilder = baseImageConfigurationBuilder;
        this.containerConfigurationBuilder = containerConfigurationBuilder;
        this.mavenSettingsServerCredentials = mavenSettingsServerCredentials;
        this.isBaseImageCredentialPresent = isBaseImageCredentialPresent;
    }

    BuildConfiguration.Builder getBuildConfigurationBuilder() {
        return this.buildConfigurationBuilder;
    }

    ImageConfiguration.Builder getBaseImageConfigurationBuilder() {
        return this.baseImageConfigurationBuilder;
    }

    ContainerConfiguration.Builder getContainerConfigurationBuilder() {
        return this.containerConfigurationBuilder;
    }

    MavenSettingsServerCredentials getMavenSettingsServerCredentials() {
        return this.mavenSettingsServerCredentials;
    }

    boolean isBaseImageCredentialPresent() {
        return this.isBaseImageCredentialPresent;
    }
}

