/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;

public class LayerConfiguration {
    private final ImmutableList<Path> sourceFiles;
    private final String destinationOnImage;

    public LayerConfiguration(List<Path> sourceFiles, String destinationOnImage) {
        Preconditions.checkArgument((!sourceFiles.contains(null) ? 1 : 0) != 0);
        this.sourceFiles = ImmutableList.copyOf(sourceFiles);
        this.destinationOnImage = destinationOnImage;
    }

    public ImmutableList<Path> getSourceFiles() {
        return this.sourceFiles;
    }

    public String getDestinationOnImage() {
        return this.destinationOnImage;
    }
}

