/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class CacheMetadata {
    private final ImageLayers<CachedLayerWithMetadata> layers;

    static Builder builder() {
        return new Builder();
    }

    private CacheMetadata(ImageLayers<CachedLayerWithMetadata> layers) {
        this.layers = layers;
    }

    ImageLayers<CachedLayerWithMetadata> getLayers() {
        return this.layers;
    }

    LayerFilter filterLayers() {
        return new LayerFilter(this.layers);
    }

    Builder newAppendingBuilder() {
        return new Builder(this.layers);
    }

    static class LayerFilter {
        private final ImageLayers<CachedLayerWithMetadata> layers;
        @Nullable
        private ImmutableList<LayerEntry> layerEntries;

        @VisibleForTesting
        static boolean doLayerEntriesMatchMetadataEntries(ImmutableList<LayerEntry> layerEntries, ImmutableList<LayerMetadata.LayerMetadataEntry> metadataEntries) {
            if (layerEntries.size() != metadataEntries.size()) {
                return false;
            }
            return Streams.zip((Stream)layerEntries.stream(), (Stream)metadataEntries.stream(), (layerEntry, metadataEntry) -> {
                if (!layerEntry.getExtractionPath().equals(metadataEntry.getExtractionPath())) {
                    return true;
                }
                if (layerEntry.getSourceFiles().size() != metadataEntry.getSourceFilesStrings().size()) {
                    return true;
                }
                return Streams.zip((Stream)layerEntry.getSourceFiles().stream(), metadataEntry.getSourceFilesStrings().stream(), (sourceFile, sourceFileString) -> !sourceFile.equals(Paths.get(sourceFileString, new String[0]))).anyMatch(isNotEqual -> isNotEqual);
            }).noneMatch(isNotEqual -> isNotEqual);
        }

        private LayerFilter(ImageLayers<CachedLayerWithMetadata> layers) {
            this.layers = layers;
        }

        LayerFilter byLayerEntries(ImmutableList<LayerEntry> layerEntries) {
            this.layerEntries = layerEntries;
            return this;
        }

        ImageLayers<CachedLayerWithMetadata> filter() throws CacheMetadataCorruptedException {
            try {
                ImageLayers.Builder filteredLayersBuilder = ImageLayers.builder();
                for (CachedLayerWithMetadata layer : this.layers) {
                    if (this.layerEntries != null && (layer.getMetadata() == null || !LayerFilter.doLayerEntriesMatchMetadataEntries(this.layerEntries, layer.getMetadata().getEntries()))) continue;
                    filteredLayersBuilder.add(layer);
                }
                return filteredLayersBuilder.build();
            }
            catch (LayerPropertyNotFoundException ex) {
                throw new CacheMetadataCorruptedException(ex);
            }
        }
    }

    static class Builder {
        private final ImageLayers.Builder<CachedLayerWithMetadata> layersBuilder = ImageLayers.builder();

        private Builder(ImageLayers<CachedLayerWithMetadata> initialLayers) {
            this.layersBuilder.addAll(initialLayers);
        }

        private Builder() {
        }

        Builder addLayer(CachedLayerWithMetadata layer) {
            this.layersBuilder.add(layer);
            return this;
        }

        CacheMetadata build() {
            return new CacheMetadata(this.layersBuilder.build());
        }
    }
}

