/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerPropertiesObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class CacheMetadataTranslator {
    static CacheMetadata fromTemplate(CacheMetadataTemplate template, Path cacheDirectory) throws CacheMetadataCorruptedException {
        CacheMetadata.Builder cacheMetadataBuilder = CacheMetadata.builder();
        for (CacheMetadataLayerObjectTemplate layerObjectTemplate : template.getLayers()) {
            if (layerObjectTemplate.getDigest() == null || layerObjectTemplate.getDiffId() == null) {
                throw new CacheMetadataCorruptedException("Cannot translate cache metadata layer without a digest or diffId");
            }
            Path layerContentFile = CacheFiles.getLayerFile(cacheDirectory, layerObjectTemplate.getDigest());
            CacheMetadataLayerPropertiesObjectTemplate propertiesObjectTemplate = layerObjectTemplate.getProperties();
            LayerMetadata layerMetadata = null;
            if (propertiesObjectTemplate != null) {
                ImmutableList.Builder layerEntries = ImmutableList.builderWithExpectedSize((int)propertiesObjectTemplate.getLayerEntries().size());
                for (CacheMetadataLayerPropertiesObjectTemplate.LayerEntryTemplate layerEntryTemplate : propertiesObjectTemplate.getLayerEntries()) {
                    if (layerEntryTemplate.getSourceFiles() == null || layerEntryTemplate.getExtractionPath() == null) {
                        throw new CacheMetadataCorruptedException("Cannot translate cache metadata layer entry without source files or extraction path");
                    }
                    layerEntries.add((Object)new LayerEntry((ImmutableList<Path>)((ImmutableList)layerEntryTemplate.getSourceFiles().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList())), layerEntryTemplate.getExtractionPath()));
                }
                layerMetadata = LayerMetadata.from((ImmutableList<LayerEntry>)layerEntries.build(), propertiesObjectTemplate.getLastModifiedTime());
            }
            CachedLayer cachedLayer = new CachedLayer(layerContentFile, new BlobDescriptor(layerObjectTemplate.getSize(), layerObjectTemplate.getDigest()), layerObjectTemplate.getDiffId());
            CachedLayerWithMetadata cachedLayerWithMetadata = new CachedLayerWithMetadata(cachedLayer, layerMetadata);
            cacheMetadataBuilder.addLayer(cachedLayerWithMetadata);
        }
        return cacheMetadataBuilder.build();
    }

    static CacheMetadataTemplate toTemplate(CacheMetadata cacheMetadata) {
        CacheMetadataTemplate template = new CacheMetadataTemplate();
        for (CachedLayerWithMetadata cachedLayerWithMetadata : cacheMetadata.getLayers()) {
            CacheMetadataLayerObjectTemplate layerObjectTemplate = new CacheMetadataLayerObjectTemplate().setSize(cachedLayerWithMetadata.getBlobDescriptor().getSize()).setDigest(cachedLayerWithMetadata.getBlobDescriptor().getDigest()).setDiffId(cachedLayerWithMetadata.getDiffId());
            if (cachedLayerWithMetadata.getMetadata() != null) {
                List<CacheMetadataLayerPropertiesObjectTemplate.LayerEntryTemplate> layerEntryTemplates = cachedLayerWithMetadata.getMetadata().getEntries().stream().map(layerMetadataEntry -> new CacheMetadataLayerPropertiesObjectTemplate.LayerEntryTemplate(layerMetadataEntry.getSourceFilesStrings(), layerMetadataEntry.getExtractionPath())).collect(Collectors.toList());
                layerObjectTemplate.setProperties(new CacheMetadataLayerPropertiesObjectTemplate().setLayerEntries(layerEntryTemplates).setLastModifiedTime(cachedLayerWithMetadata.getMetadata().getLastModifiedTime()));
            }
            template.addLayer(layerObjectTemplate);
        }
        return template;
    }
}

