/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;

class LayerMetadata {
    private ImmutableList<LayerMetadataEntry> entries;
    private final FileTime lastModifiedTime;

    static LayerMetadata from(ImmutableList<LayerEntry> layerEntries, FileTime lastModifiedTime) {
        ImmutableList.Builder entries = ImmutableList.builderWithExpectedSize((int)layerEntries.size());
        for (LayerEntry layerEntry : layerEntries) {
            ImmutableList<Path> sourceFiles = layerEntry.getSourceFiles();
            ArrayList<String> sourceFilesStrings = new ArrayList<String>(sourceFiles.size());
            for (Path sourceFile : sourceFiles) {
                sourceFilesStrings.add(sourceFile.toString());
            }
            entries.add((Object)new LayerMetadataEntry(sourceFilesStrings, layerEntry.getExtractionPath()));
        }
        return new LayerMetadata((ImmutableList<LayerMetadataEntry>)entries.build(), lastModifiedTime);
    }

    LayerMetadata(ImmutableList<LayerMetadataEntry> entries, FileTime lastModifiedTime) {
        this.entries = entries;
        this.lastModifiedTime = lastModifiedTime;
    }

    ImmutableList<LayerMetadataEntry> getEntries() {
        return this.entries;
    }

    FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @VisibleForTesting
    void setEntries(ImmutableList<LayerMetadataEntry> entries) {
        this.entries = entries;
    }

    static class LayerMetadataEntry {
        private List<String> sourceFilesStrings;
        private String extractionPath;

        List<String> getSourceFilesStrings() {
            return this.sourceFilesStrings;
        }

        String getExtractionPath() {
            return this.extractionPath;
        }

        @VisibleForTesting
        LayerMetadataEntry(List<String> sourceFilesStrings, String extractionPath) {
            this.sourceFilesStrings = sourceFilesStrings;
            this.extractionPath = extractionPath;
        }
    }
}

