/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ReproducibleLayerBuilder {
    private final ImmutableList.Builder<LayerEntry> layerEntries = ImmutableList.builder();

    private static List<TarArchiveEntry> buildAsTarArchiveEntries(LayerEntry layerEntry) throws IOException {
        ArrayList<TarArchiveEntry> tarArchiveEntries = new ArrayList<TarArchiveEntry>();
        for (Path sourceFile : layerEntry.getSourceFiles()) {
            if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                new DirectoryWalker(sourceFile).filterRoot().walk(path -> {
                    StringBuilder subExtractionPath = new StringBuilder(layerEntry.getExtractionPath());
                    Path sourceFileRelativePath = sourceFile.getParent().relativize(path);
                    for (Path sourceFileRelativePathComponent : sourceFileRelativePath) {
                        subExtractionPath.append('/').append(sourceFileRelativePathComponent);
                    }
                    tarArchiveEntries.add(new TarArchiveEntry(path.toFile(), subExtractionPath.toString()));
                });
                continue;
            }
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(sourceFile.toFile(), layerEntry.getExtractionPath() + "/" + sourceFile.getFileName());
            tarArchiveEntries.add(tarArchiveEntry);
        }
        return tarArchiveEntries;
    }

    public ReproducibleLayerBuilder addFiles(List<Path> sourceFiles, String extractionPath) {
        this.layerEntries.add((Object)new LayerEntry((ImmutableList<Path>)ImmutableList.copyOf(sourceFiles), extractionPath));
        return this;
    }

    public UnwrittenLayer build() throws IOException {
        ArrayList<TarArchiveEntry> filesystemEntries = new ArrayList<TarArchiveEntry>();
        for (LayerEntry layerEntry : this.layerEntries.build()) {
            filesystemEntries.addAll(ReproducibleLayerBuilder.buildAsTarArchiveEntries(layerEntry));
        }
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        filesystemEntries.sort(Comparator.comparing(TarArchiveEntry::getName));
        for (TarArchiveEntry entry : filesystemEntries) {
            entry.setModTime(0L);
            entry.setGroupId(0);
            entry.setUserId(0);
            entry.setUserName("");
            entry.setGroupName("");
            tarStreamBuilder.addEntry(entry);
        }
        return new UnwrittenLayer(tarStreamBuilder.toBlob());
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        return this.layerEntries.build();
    }
}

