/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.annotation.Nullable;

public abstract class RegistryAuthenticators {
    public static RegistryAuthenticator forDockerHub(String repository) {
        return new RegistryAuthenticator("https://auth.docker.io/token", "registry.docker.io", repository);
    }

    @Nullable
    public static RegistryAuthenticator forOther(String serverUrl, String repository) throws RegistryAuthenticationFailedException, IOException, RegistryException {
        try {
            return RegistryClient.factory(serverUrl, repository).newRegistryClient().getRegistryAuthenticator();
        }
        catch (MalformedURLException ex) {
            throw new RegistryAuthenticationFailedException(ex);
        }
        catch (InsecureRegistryException ex) {
            return null;
        }
    }
}

