/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib;

import com.google.cloud.tools.jib.builder.BuildLogger;
import java.io.Closeable;
import javax.annotation.Nullable;

public class Timer
implements Closeable {
    private final BuildLogger buildLogger;
    private final int depth;
    @Nullable
    private String label;
    private long startTime = System.nanoTime();

    public Timer(BuildLogger buildLogger, String label) {
        this(buildLogger, label, 0);
    }

    private Timer(BuildLogger buildLogger, String label, int depth) {
        this.buildLogger = buildLogger;
        this.label = label;
        this.depth = depth;
        if (buildLogger != null) {
            buildLogger.debug(this.getTabs().append("TIMING\t").append(label));
            if (depth == 0) {
                buildLogger.info("RUNNING\t" + label);
            }
        }
    }

    public Timer subTimer(String label) {
        return new Timer(this.buildLogger, label, this.depth + 1);
    }

    public void lap(@Nullable String label) {
        if (this.label == null) {
            throw new IllegalStateException("Tried to lap Timer after closing");
        }
        if (this.buildLogger != null) {
            double timeInMillis = (double)((System.nanoTime() - this.startTime) / 1000L) / 1000.0;
            this.buildLogger.debug(this.getTabs().append("TIMED\t").append(this.label).append(" : ").append(timeInMillis).append(" ms"));
            if (this.depth == 0) {
                this.buildLogger.info(this.label + " : " + timeInMillis + " ms");
            }
        }
        this.label = label;
        this.startTime = System.nanoTime();
    }

    private StringBuilder getTabs() {
        StringBuilder tabs = new StringBuilder();
        for (int i = 0; i < this.depth; ++i) {
            tabs.append("\t");
        }
        return tabs;
    }

    @Override
    public void close() {
        this.lap(null);
    }
}

