/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PushBlobStep
implements AsyncStep<BlobDescriptor>,
Callable<BlobDescriptor> {
    private static final String DESCRIPTION = "Pushing BLOB ";
    private final BuildConfiguration buildConfiguration;
    private final AuthenticatePushStep authenticatePushStep;
    private final BlobDescriptor blobDescriptor;
    private final Blob blob;
    private final ListenableFuture<BlobDescriptor> listenableFuture;

    PushBlobStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, AuthenticatePushStep authenticatePushStep, BlobDescriptor blobDescriptor, Blob blob) {
        this.buildConfiguration = buildConfiguration;
        this.authenticatePushStep = authenticatePushStep;
        this.blobDescriptor = blobDescriptor;
        this.blob = blob;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{authenticatePushStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<BlobDescriptor> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BlobDescriptor call() throws IOException, RegistryException, ExecutionException {
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION + this.blobDescriptor);){
            RegistryClient registryClient = RegistryClient.factory(this.buildConfiguration.getTargetImageRegistry(), this.buildConfiguration.getTargetImageRepository()).setAllowHttp(this.buildConfiguration.getAllowHttp()).setAuthorization(NonBlockingSteps.get(this.authenticatePushStep)).newRegistryClient();
            registryClient.setTimer(timer);
            if (registryClient.checkBlob(this.blobDescriptor.getDigest()) != null) {
                this.buildConfiguration.getBuildLogger().info("BLOB : " + this.blobDescriptor + " already exists on registry");
                BlobDescriptor blobDescriptor = this.blobDescriptor;
                return blobDescriptor;
            }
            registryClient.pushBlob(this.blobDescriptor.getDigest(), this.blob);
            BlobDescriptor blobDescriptor = this.blobDescriptor;
            return blobDescriptor;
        }
    }
}

