/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CacheWriter {
    private final Cache cache;

    public CacheWriter(Cache cache) {
        this.cache = cache;
    }

    public CachedLayerWithMetadata writeLayer(ReproducibleLayerBuilder reproducibleLayerBuilder) throws IOException {
        UnwrittenLayer unwrittenLayer = reproducibleLayerBuilder.build();
        Path tempLayerFile = Files.createTempFile(this.cache.getCacheDirectory(), null, null, new FileAttribute[0]);
        tempLayerFile.toFile().deleteOnExit();
        try (CountingDigestOutputStream compressedDigestOutputStream = new CountingDigestOutputStream(new BufferedOutputStream(Files.newOutputStream(tempLayerFile, new OpenOption[0])));){
            GZIPOutputStream compressorStream = new GZIPOutputStream(compressedDigestOutputStream);
            DescriptorDigest diffId = unwrittenLayer.getBlob().writeTo(compressorStream).getDigest();
            compressorStream.close();
            BlobDescriptor compressedBlobDescriptor = compressedDigestOutputStream.toBlobDescriptor();
            Path layerFile = this.getLayerFile(compressedBlobDescriptor.getDigest());
            Files.move(tempLayerFile, layerFile, StandardCopyOption.REPLACE_EXISTING);
            CachedLayer cachedLayer = new CachedLayer(layerFile, compressedBlobDescriptor, diffId);
            LayerMetadata layerMetadata = LayerMetadata.from(reproducibleLayerBuilder.getLayerEntries(), FileTime.from(Instant.now()));
            CachedLayerWithMetadata cachedLayerWithMetadata = new CachedLayerWithMetadata(cachedLayer, layerMetadata);
            return cachedLayerWithMetadata;
        }
    }

    public CountingOutputStream getLayerOutputStream(DescriptorDigest layerDigest) throws IOException {
        Path layerFile = this.getLayerFile(layerDigest);
        return new CountingOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(layerFile, new OpenOption[0])));
    }

    public CachedLayer getCachedLayer(long layerSize, DescriptorDigest layerDigest) throws IOException {
        Path layerFile = this.getLayerFile(layerDigest);
        return new CachedLayer(layerFile, new BlobDescriptor(layerSize, layerDigest), this.getDiffId(layerFile));
    }

    private Path getLayerFile(DescriptorDigest compressedDigest) {
        return CacheFiles.getLayerFile(this.cache.getCacheDirectory(), compressedDigest);
    }

    private DescriptorDigest getDiffId(Path layerFile) throws IOException {
        CountingDigestOutputStream diffIdCaptureOutputStream = new CountingDigestOutputStream(ByteStreams.nullOutputStream());
        try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(layerFile, new OpenOption[0]));
             GZIPInputStream decompressorStream = new GZIPInputStream(fileInputStream);){
            ByteStreams.copy((InputStream)decompressorStream, (OutputStream)diffIdCaptureOutputStream);
        }
        return diffIdCaptureOutputStream.toBlobDescriptor().getDigest();
    }
}

