/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;

public class LayerConfiguration {
    private final ImmutableList<LayerEntry> layerEntries;

    public static Builder builder() {
        return new Builder();
    }

    private LayerConfiguration(ImmutableList<LayerEntry> layerEntries) {
        this.layerEntries = layerEntries;
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        return this.layerEntries;
    }

    public static class Builder {
        private final ImmutableList.Builder<LayerEntry> layerEntries = ImmutableList.builder();

        private Builder() {
        }

        public Builder addEntry(List<Path> sourceFiles, String destinationOnImage) {
            Preconditions.checkArgument((!sourceFiles.contains(null) ? 1 : 0) != 0);
            this.layerEntries.add((Object)new LayerEntry((ImmutableList<Path>)ImmutableList.copyOf(sourceFiles), destinationOnImage));
            return this;
        }

        public LayerConfiguration build() {
            return new LayerConfiguration(this.layerEntries.build());
        }
    }
}

