/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class Image<T extends Layer> {
    private final ImageLayers<T> layers;
    private final ImmutableList<String> environmentBuilder;
    private final ImmutableList<String> entrypoint;
    private final ImmutableList<String> javaArguments;
    private final ImmutableList<Port> exposedPorts;

    public static <T extends Layer> Builder<T> builder() {
        return new Builder();
    }

    private Image(ImageLayers<T> layers, ImmutableList<String> environment, ImmutableList<String> entrypoint, ImmutableList<String> javaArguments, ImmutableList<Port> exposedPorts) {
        this.layers = layers;
        this.environmentBuilder = environment;
        this.entrypoint = entrypoint;
        this.javaArguments = javaArguments;
        this.exposedPorts = exposedPorts;
    }

    public ImmutableList<String> getEnvironment() {
        return this.environmentBuilder;
    }

    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    public ImmutableList<T> getLayers() {
        return this.layers.getLayers();
    }

    public static class Builder<T extends Layer> {
        private final ImageLayers.Builder<T> imageLayersBuilder = ImageLayers.builder();
        private final ImmutableList.Builder<String> environmentBuilder = ImmutableList.builder();
        private ImmutableList<String> entrypoint = ImmutableList.of();
        private ImmutableList<String> javaArguments = ImmutableList.of();
        private ImmutableList<Port> exposedPorts = ImmutableList.of();

        public Builder<T> setEnvironment(Map<String, String> environment) {
            for (Map.Entry<String, String> environmentVariable : environment.entrySet()) {
                this.setEnvironmentVariable(environmentVariable.getKey(), environmentVariable.getValue());
            }
            return this;
        }

        public Builder<T> setEnvironmentVariable(String name, String value) {
            this.environmentBuilder.add((Object)(name + "=" + value));
            return this;
        }

        public Builder<T> addEnvironmentVariableDefinition(String environmentVariableDefinition) {
            this.environmentBuilder.add((Object)environmentVariableDefinition);
            return this;
        }

        public Builder<T> setEntrypoint(List<String> entrypoint) {
            this.entrypoint = ImmutableList.copyOf(entrypoint);
            return this;
        }

        public Builder<T> setJavaArguments(List<String> javaArguments) {
            this.javaArguments = ImmutableList.copyOf(javaArguments);
            return this;
        }

        public Builder<T> setExposedPorts(ImmutableList<Port> exposedPorts) {
            this.exposedPorts = exposedPorts;
            return this;
        }

        public Builder<T> addLayer(T layer) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add(layer);
            return this;
        }

        public Image<T> build() {
            return new Image(this.imageLayersBuilder.build(), this.environmentBuilder.build(), ImmutableList.copyOf(this.entrypoint), ImmutableList.copyOf(this.javaArguments), this.exposedPorts);
        }
    }
}

