/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerConfigurationTemplate
implements JsonTemplate {
    private String created = "1970-01-01T00:00:00Z";
    private String architecture = "amd64";
    private String os = "linux";
    private final ConfigurationObjectTemplate config = new ConfigurationObjectTemplate();
    private final RootFilesystemObjectTemplate rootfs = new RootFilesystemObjectTemplate();

    public void setContainerEnvironment(List<String> environment) {
        this.config.Env = environment;
    }

    public void setContainerEntrypoint(List<String> command) {
        this.config.Entrypoint = command;
    }

    public void setContainerCmd(List<String> cmd) {
        this.config.Cmd = cmd;
    }

    public void setContainerExposedPorts(Map<String, Map<?, ?>> exposedPorts) {
        this.config.ExposedPorts = exposedPorts;
    }

    public void addLayerDiffId(DescriptorDigest diffId) {
        this.rootfs.diff_ids.add(diffId);
    }

    List<DescriptorDigest> getDiffIds() {
        return this.rootfs.diff_ids;
    }

    @Nullable
    List<String> getContainerEnvironment() {
        return this.config.Env;
    }

    @Nullable
    List<String> getContainerEntrypoint() {
        return this.config.Entrypoint;
    }

    @Nullable
    List<String> getContainerCmd() {
        return this.config.Cmd;
    }

    @Nullable
    Map<String, Map<?, ?>> getContainerExposedPorts() {
        return this.config.ExposedPorts;
    }

    @VisibleForTesting
    DescriptorDigest getLayerDiffId(int index) {
        return (DescriptorDigest)this.rootfs.diff_ids.get(index);
    }

    private static class RootFilesystemObjectTemplate
    implements JsonTemplate {
        private final String type = "layers";
        private final List<DescriptorDigest> diff_ids = new ArrayList<DescriptorDigest>();

        private RootFilesystemObjectTemplate() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConfigurationObjectTemplate
    implements JsonTemplate {
        @Nullable
        private List<String> Env;
        @Nullable
        private List<String> Entrypoint;
        @Nullable
        private List<String> Cmd;
        @Nullable
        private Map<String, Map<?, ?>> ExposedPorts;

        private ConfigurationObjectTemplate() {
        }
    }
}

