/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter(property="image")
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private ContainerParameters container = new ContainerParameters();
    @Deprecated
    @Parameter
    private List<String> jvmFlags = Collections.emptyList();
    @Nullable
    @Parameter
    private Map<String, String> environment;
    @Deprecated
    @Nullable
    @Parameter
    private String mainClass;
    @Deprecated
    @Parameter
    private List<String> args = Collections.emptyList();
    @Deprecated
    @Nullable
    @Parameter
    private String format;
    @Parameter(defaultValue="false", required=true)
    private boolean useOnlyProjectCache;
    @Parameter(defaultValue="false", required=true)
    private boolean allowInsecureRegistries;
    @Nullable
    @Parameter(defaultValue="${project.basedir}/src/main/jib", required=true)
    private String extraDirectory;

    JibPluginConfiguration() {
    }

    static ImageReference parseImageReference(String image, String type) {
        try {
            return ImageReference.parse(image);
        }
        catch (InvalidImageReferenceException ex) {
            throw new IllegalStateException("Parameter '" + type + "' is invalid", ex);
        }
    }

    void handleDeprecatedParameters(BuildLogger logger) {
        StringBuilder deprecatedParams = new StringBuilder();
        if (!this.jvmFlags.isEmpty()) {
            deprecatedParams.append("  <jvmFlags> -> <container><jvmFlags>\n");
            if (this.container.jvmFlags.isEmpty()) {
                this.container.jvmFlags = this.jvmFlags;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.mainClass)) {
            deprecatedParams.append("  <mainClass> -> <container><mainClass>\n");
            if (Strings.isNullOrEmpty((String)this.container.mainClass)) {
                this.container.mainClass = this.mainClass;
            }
        }
        if (!this.args.isEmpty()) {
            deprecatedParams.append("  <args> -> <container><args>\n");
            if (this.container.args.isEmpty()) {
                this.container.args = this.args;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.format)) {
            deprecatedParams.append("  <format> -> <container><format>\n");
            this.container.format = this.format;
        }
        if (deprecatedParams.length() > 0) {
            logger.warn("There are deprecated parameters used in the build configuration. Please make the following changes to your pom.xml to avoid issues in the future:\n" + deprecatedParams);
        }
    }

    MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    String getBaseImage() {
        return (String)Preconditions.checkNotNull((Object)((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).image);
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).credHelper;
    }

    @Nullable
    String getTargetImage() {
        return this.to.image;
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        return ((ToConfiguration)Preconditions.checkNotNull((Object)this.to)).credHelper;
    }

    List<String> getJvmFlags() {
        return this.container.jvmFlags;
    }

    @Nullable
    Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    String getMainClass() {
        return this.container.mainClass;
    }

    List<String> getArgs() {
        return this.container.args;
    }

    List<String> getExposedPorts() {
        return this.container.ports;
    }

    String getFormat() {
        return (String)Preconditions.checkNotNull((Object)this.container.format);
    }

    boolean getUseOnlyProjectCache() {
        return this.useOnlyProjectCache;
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    @Nullable
    Path getExtraDirectory() {
        return Paths.get(this.extraDirectory, new String[0]);
    }

    @VisibleForTesting
    void setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
    }

    @VisibleForTesting
    void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @VisibleForTesting
    void setArgs(List<String> args) {
        this.args = args;
    }

    @VisibleForTesting
    void setFormat(String format) {
        this.format = format;
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    @VisibleForTesting
    void setTargetImage(@Nullable String targetImage) {
        this.to.image = targetImage;
    }

    @VisibleForTesting
    void setExtraDirectory(String extraDirectory) {
        this.extraDirectory = extraDirectory;
    }

    public static class ContainerParameters {
        @Parameter
        private List<String> jvmFlags = Collections.emptyList();
        @Nullable
        @Parameter
        private String mainClass;
        @Parameter
        private List<String> args = Collections.emptyList();
        @Nullable
        @Parameter(required=true)
        private String format = "Docker";
        @Parameter
        private List<String> ports = Collections.emptyList();
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Nullable
        @Parameter
        private String credHelper;

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter(required=true)
        private String image = "gcr.io/distroless/java";
        @Nullable
        @Parameter
        private String credHelper;
    }
}

