/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class BuildImageStep
implements AsyncStep<AsyncStep<Image<CachedLayer>>>,
Callable<AsyncStep<Image<CachedLayer>>> {
    private static final String DESCRIPTION = "Building container configuration";
    private final BuildConfiguration buildConfiguration;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final ImmutableList<String> entrypoint;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<AsyncStep<Image<CachedLayer>>> listenableFuture;

    BuildImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps, ImmutableList<String> entrypoint) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = buildAndCacheApplicationLayerSteps;
        this.entrypoint = entrypoint;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullAndCacheBaseImageLayersStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<AsyncStep<Image<CachedLayer>>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public AsyncStep<Image<CachedLayer>> call() throws ExecutionException {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
            dependencies.add(pullAndCacheBaseImageLayerStep.getFuture());
        }
        for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
            dependencies.add(buildAndCacheApplicationLayerStep.getFuture());
        }
        ListenableFuture future = Futures.whenAllSucceed(dependencies).call(this::afterCachedLayersSteps, (Executor)this.listeningExecutorService);
        return () -> future;
    }

    private Image<CachedLayer> afterCachedLayersSteps() throws ExecutionException, LayerPropertyNotFoundException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            Image.Builder<CachedLayer> imageBuilder = Image.builder();
            for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
                imageBuilder.addLayer(NonBlockingSteps.get(pullAndCacheBaseImageLayerStep));
            }
            for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
                imageBuilder.addLayer(NonBlockingSteps.get(buildAndCacheApplicationLayerStep));
            }
            imageBuilder.setCreated(this.buildConfiguration.getCreationTime());
            imageBuilder.setEnvironment((Map<String, String>)this.buildConfiguration.getEnvironment());
            imageBuilder.setEntrypoint((List<String>)this.entrypoint);
            imageBuilder.setJavaArguments((List<String>)this.buildConfiguration.getJavaArguments());
            imageBuilder.setExposedPorts(this.buildConfiguration.getExposedPorts());
            Object object = imageBuilder.build();
            return object;
        }
    }
}

