/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Retrieving registry credentials for %s";
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final BuildLogger buildLogger;
    private final String registry;
    @Nullable
    private final String credentialHelperSuffix;
    @Nullable
    private final RegistryCredentials knownRegistryCredentials;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final DockerConfigCredentialRetriever dockerConfigCredentialRetriever;
    private final ListenableFuture<Authorization> listenableFuture;

    static RetrieveRegistryCredentialsStep forBaseImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getBaseImageRegistry(), buildConfiguration.getBaseImageCredentialHelperName(), buildConfiguration.getKnownBaseRegistryCredentials());
    }

    static RetrieveRegistryCredentialsStep forTargetImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageCredentialHelperName(), buildConfiguration.getKnownTargetRegistryCredentials());
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String registry, @Nullable String credentialHelperSuffix, @Nullable RegistryCredentials knownRegistryCredentials, DockerCredentialHelperFactory dockerCredentialHelperFactory, DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        this.buildLogger = buildLogger;
        this.registry = registry;
        this.credentialHelperSuffix = credentialHelperSuffix;
        this.knownRegistryCredentials = knownRegistryCredentials;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.dockerConfigCredentialRetriever = dockerConfigCredentialRetriever;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    private RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String registry, @Nullable String credentialHelperSuffix, @Nullable RegistryCredentials knownRegistryCredentials) {
        this(listeningExecutorService, buildLogger, registry, credentialHelperSuffix, knownRegistryCredentials, new DockerCredentialHelperFactory(), new DockerConfigCredentialRetriever(registry));
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    @Nullable
    public Authorization call() throws IOException, NonexistentDockerCredentialHelperException {
        this.buildLogger.lifecycle(String.format(DESCRIPTION, this.registry) + "...");
        try (Timer ignored = new Timer(this.buildLogger, String.format(DESCRIPTION, this.registry));){
            Authorization authorization;
            if (this.credentialHelperSuffix != null && (authorization = this.retrieveFromCredentialHelper(this.credentialHelperSuffix)) != null) {
                Authorization authorization2 = authorization;
                return authorization2;
            }
            if (this.knownRegistryCredentials != null) {
                this.logGotCredentialsFrom(this.knownRegistryCredentials.getCredentialSource());
                authorization = this.knownRegistryCredentials.getAuthorization();
                return authorization;
            }
            for (String registrySuffix : COMMON_CREDENTIAL_HELPERS.keySet()) {
                if (!this.registry.endsWith(registrySuffix)) continue;
                try {
                    String commonCredentialHelper = (String)COMMON_CREDENTIAL_HELPERS.get((Object)registrySuffix);
                    if (commonCredentialHelper == null) {
                        throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
                    }
                    Authorization authorization3 = this.retrieveFromCredentialHelper(commonCredentialHelper);
                    if (authorization3 == null) continue;
                    Authorization authorization4 = authorization3;
                    return authorization4;
                }
                catch (NonexistentDockerCredentialHelperException ex) {
                    if (ex.getMessage() == null) continue;
                    this.buildLogger.warn(ex.getMessage());
                }
            }
            try {
                Authorization dockerConfigAuthorization = this.dockerConfigCredentialRetriever.retrieve();
                if (dockerConfigAuthorization != null) {
                    this.buildLogger.info("Using credentials from Docker config for " + this.registry);
                    Authorization authorization5 = dockerConfigAuthorization;
                    return authorization5;
                }
            }
            catch (IOException ex) {
                this.buildLogger.info("Unable to parse Docker config");
            }
            this.buildLogger.info("No credentials could be retrieved for registry " + this.registry);
            Authorization authorization6 = null;
            return authorization6;
        }
    }

    @Nullable
    @VisibleForTesting
    Authorization retrieveFromCredentialHelper(String credentialHelperSuffix) throws NonexistentDockerCredentialHelperException, IOException {
        this.buildLogger.info("Checking credentials from docker-credential-" + credentialHelperSuffix);
        try {
            Authorization authorization = this.dockerCredentialHelperFactory.newDockerCredentialHelper(this.registry, credentialHelperSuffix).retrieve();
            this.logGotCredentialsFrom("docker-credential-" + credentialHelperSuffix);
            return authorization;
        }
        catch (NonexistentServerUrlDockerCredentialHelperException ex) {
            this.buildLogger.info("No credentials for " + this.registry + " in docker-credential-" + credentialHelperSuffix);
            return null;
        }
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.buildLogger.info("Using " + credentialSource + " for " + this.registry);
    }
}

