/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;

public class BuildStepsRunner {
    private final BuildSteps buildSteps;

    public static BuildStepsRunner forBuildImage(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerRegistry(buildConfiguration, sourceFilesConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    public static BuildStepsRunner forBuildToDockerDaemon(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerDaemon(buildConfiguration, sourceFilesConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    public static BuildStepsRunner forBuildTar(Path outputPath, BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToTar(outputPath, buildConfiguration, sourceFilesConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    private static Caches.Initializer getCacheInitializer(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        CacheConfiguration applicationLayersCacheConfiguration = buildConfiguration.getApplicationLayersCacheConfiguration() == null ? CacheConfiguration.makeTemporary() : buildConfiguration.getApplicationLayersCacheConfiguration();
        CacheConfiguration baseImageLayersCacheConfiguration = buildConfiguration.getBaseImageLayersCacheConfiguration() == null ? CacheConfiguration.forDefaultUserLevelCacheDirectory() : buildConfiguration.getBaseImageLayersCacheConfiguration();
        return new Caches.Initializer(baseImageLayersCacheConfiguration.getCacheDirectory(), applicationLayersCacheConfiguration.shouldEnsureOwnership(), applicationLayersCacheConfiguration.getCacheDirectory(), applicationLayersCacheConfiguration.shouldEnsureOwnership());
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, BuildConfiguration buildConfiguration, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        boolean areTargetImageCredentialsConfigured;
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        boolean isRegistryForBase = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getBaseImageRegistry());
        boolean isRegistryForTarget = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getTargetImageRegistry());
        boolean areBaseImageCredentialsConfigured = buildConfiguration.getBaseImageCredentialHelperName() != null || buildConfiguration.getKnownBaseRegistryCredentials() != null;
        boolean bl = areTargetImageCredentialsConfigured = buildConfiguration.getTargetImageCredentialHelperName() != null || buildConfiguration.getKnownTargetRegistryCredentials() != null;
        if (isRegistryForBase && !areBaseImageCredentialsConfigured) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForBaseImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        if (isRegistryForTarget && !areTargetImageCredentialsConfigured) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForTargetImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotCorrect(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
    }

    @VisibleForTesting
    BuildStepsRunner(BuildSteps buildSteps) {
        this.buildSteps = buildSteps;
    }

    public void build(HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        try {
            BuildLogger buildLogger = this.buildSteps.getBuildConfiguration().getBuildLogger();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getStartupMessage());
            buildLogger.info("Containerizing application with the following files:");
            buildLogger.info("\tClasses:");
            this.buildSteps.getSourceFilesConfiguration().getClassesFiles().forEach(classesFile -> buildLogger.info("\t\t" + classesFile));
            buildLogger.info("\tResources:");
            this.buildSteps.getSourceFilesConfiguration().getResourcesFiles().forEach(resourceFile -> buildLogger.info("\t\t" + resourceFile));
            buildLogger.info("\tDependencies:");
            this.buildSteps.getSourceFilesConfiguration().getDependenciesFiles().forEach(dependencyFile -> buildLogger.info("\t\t" + dependencyFile));
            this.buildSteps.run();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getSuccessMessage());
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCacheNeedsClean(), cacheMetadataCorruptedException);
        }
        catch (ExecutionException executionException) {
            BuildConfiguration buildConfiguration = this.buildSteps.getBuildConfiguration();
            Throwable exceptionDuringBuildSteps = executionException.getCause();
            if (exceptionDuringBuildSteps instanceof HttpHostConnectException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forHttpHostConnect(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryUnauthorizedException) {
                BuildStepsRunner.handleRegistryUnauthorizedException((RegistryUnauthorizedException)exceptionDuringBuildSteps, buildConfiguration, helpfulSuggestions);
            }
            if (exceptionDuringBuildSteps instanceof RegistryCredentialsNotSentException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotSent(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryAuthenticationFailedException && exceptionDuringBuildSteps.getCause() instanceof HttpResponseException) {
                BuildStepsRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageRepository(), (HttpResponseException)exceptionDuringBuildSteps.getCause()), buildConfiguration, helpfulSuggestions);
            }
            if (exceptionDuringBuildSteps instanceof UnknownHostException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forUnknownHost(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof InsecureRegistryException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forInsecureRegistry(), exceptionDuringBuildSteps);
            }
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), executionException.getCause());
        }
        catch (CacheDirectoryCreationException | IOException | InterruptedException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), ex);
        }
        catch (CacheDirectoryNotOwnedException ex) {
            String helpfulSuggestion = helpfulSuggestions.forCacheDirectoryNotOwned(ex.getCacheDirectory());
            CacheConfiguration applicationLayersCacheConfiguration = this.buildSteps.getBuildConfiguration().getApplicationLayersCacheConfiguration();
            if (applicationLayersCacheConfiguration != null && ex.getCacheDirectory().equals(applicationLayersCacheConfiguration.getCacheDirectory())) {
                helpfulSuggestion = helpfulSuggestions.forCacheNeedsClean();
            }
            throw new BuildStepsExecutionException(helpfulSuggestion, ex);
        }
    }
}

