/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import java.util.function.Function;

public class SystemPropertyValidator {
    public static <T extends Throwable> void checkHttpTimeoutProperty(Function<String, T> exceptionFactory) throws T {
        String value = System.getProperty("jib.httpTimeout");
        try {
            if (value != null && Integer.parseInt(value) < 0) {
                throw (Throwable)exceptionFactory.apply("jib.httpTimeout cannot be negative: " + value);
            }
        }
        catch (NumberFormatException ex) {
            throw (Throwable)exceptionFactory.apply("jib.httpTimeout must be an integer: " + value);
        }
    }

    private SystemPropertyValidator() {
    }
}

