/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.frontend.SystemPropertyValidator;
import com.google.cloud.tools.jib.image.ImageFormat;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildImageMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "build";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    private static final HelpfulSuggestions HELPFUL_SUGGESTIONS = HelpfulSuggestionsProvider.get("Build image failed");

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenBuildLogger mavenBuildLogger = new MavenBuildLogger(this.getLog());
        this.handleDeprecatedParameters(mavenBuildLogger);
        SystemPropertyValidator.checkHttpTimeoutProperty(MojoExecutionException::new);
        if (Arrays.stream(ImageFormat.values()).noneMatch(value -> value.name().equals(this.getFormat()))) {
            throw new MojoFailureException("<format> parameter is configured with value '" + this.getFormat() + "', but the only valid configuration options are '" + (Object)((Object)ImageFormat.Docker) + "' and '" + (Object)((Object)ImageFormat.OCI) + "'.");
        }
        ImageReference baseImage = BuildImageMojo.parseImageReference(this.getBaseImage(), "from");
        if (Strings.isNullOrEmpty((String)this.getTargetImage())) {
            throw new MojoFailureException(HelpfulSuggestionsProvider.get("Missing target image parameter").forToNotConfigured("<to><image>", "pom.xml", "mvn compile jib:build -Dimage=<your image name>"));
        }
        ImageReference targetImage = BuildImageMojo.parseImageReference(this.getTargetImage(), "to");
        if (Boolean.getBoolean("sendCredentialsOverHttp")) {
            mavenBuildLogger.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!");
        }
        MavenSettingsServerCredentials mavenSettingsServerCredentials = new MavenSettingsServerCredentials(((MavenSession)Preconditions.checkNotNull((Object)this.session)).getSettings(), this.settingsDecrypter, mavenBuildLogger);
        RegistryCredentials knownBaseRegistryCredentials = mavenSettingsServerCredentials.retrieve(baseImage.getRegistry());
        RegistryCredentials knownTargetRegistryCredentials = mavenSettingsServerCredentials.retrieve(targetImage.getRegistry());
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), mavenBuildLogger);
        String mainClass = mavenProjectProperties.getMainClass(this);
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(mavenBuildLogger).setBaseImage(baseImage).setBaseImageCredentialHelperName(this.getBaseImageCredentialHelperName()).setKnownBaseRegistryCredentials(knownBaseRegistryCredentials).setTargetImage(targetImage).setTargetImageCredentialHelperName(this.getTargetImageCredentialHelperName()).setKnownTargetRegistryCredentials(knownTargetRegistryCredentials).setMainClass(mainClass).setJavaArguments(this.getArgs()).setJvmFlags(this.getJvmFlags()).setEnvironment(this.getEnvironment()).setExposedPorts((List<Port>)ExposedPortsParser.parse(this.getExposedPorts())).setTargetFormat(ImageFormat.valueOf(this.getFormat()).getManifestTemplateClass()).setAllowHttp(this.getAllowInsecureRegistries());
        if (this.getExtraDirectory() != null && Files.exists(this.getExtraDirectory(), new LinkOption[0])) {
            try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(this.getExtraDirectory());){
                buildConfigurationBuilder.setExtraFilesLayerConfiguration(LayerConfiguration.builder().addEntry(extraFilesLayerDirectoryFiles.collect(Collectors.toList()), "/").build());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to list directory for extra files: " + this.getExtraDirectory(), (Exception)ex);
            }
        }
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(mavenProjectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (this.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        if (this.getUseCurrentTimestamp()) {
            mavenBuildLogger.warn("Setting image creation time to current time; your image may not be reproducible.");
            buildConfigurationBuilder.setCreationTime(Instant.now());
        }
        BuildConfiguration buildConfiguration = buildConfigurationBuilder.build();
        MavenBuildLogger.disableHttpLogging();
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        try {
            BuildStepsRunner.forBuildImage(buildConfiguration, mavenProjectProperties.getSourceFilesConfiguration()).build(HELPFUL_SUGGESTIONS);
            this.getLog().info((CharSequence)"");
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

