/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.docker.DockerContextGenerator;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.SystemPropertyValidator;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.InsecureRecursiveDeleteException;
import java.io.IOException;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="exportDockerContext", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class DockerContextMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "exportDockerContext";
    @Nullable
    @Parameter(property="jibTargetDir", defaultValue="${project.build.directory}/jib-docker-context", required=true)
    private String targetDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenBuildLogger mavenBuildLogger = new MavenBuildLogger(this.getLog());
        this.handleDeprecatedParameters(mavenBuildLogger);
        SystemPropertyValidator.checkHttpTimeoutProperty(MojoExecutionException::new);
        Preconditions.checkNotNull((Object)this.targetDir);
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), mavenBuildLogger);
        String mainClass = mavenProjectProperties.getMainClass(this);
        try {
            ExposedPortsParser.parse(this.getExposedPorts());
            new DockerContextGenerator(mavenProjectProperties.getSourceFilesConfiguration()).setBaseImage(this.getBaseImage()).setJvmFlags(this.getJvmFlags()).setMainClass(mainClass).setJavaArguments(this.getArgs()).setExposedPorts(this.getExposedPorts()).generate(Paths.get(this.targetDir, new String[0]));
            mavenBuildLogger.lifecycle("Created Docker context at " + this.targetDir);
        }
        catch (InsecureRecursiveDeleteException ex) {
            throw new MojoExecutionException(HelpfulSuggestionsProvider.get("Export Docker context failed because cannot clear directory '" + this.targetDir + "' safely").forDockerContextInsecureRecursiveDelete(this.targetDir), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(HelpfulSuggestionsProvider.get("Export Docker context failed").suggest("check if `targetDir` is set correctly"), (Exception)ex);
        }
    }
}

