/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenSourceFilesConfiguration
implements SourceFilesConfiguration {
    private final ImmutableList<Path> dependenciesFiles;
    private final ImmutableList<Path> snapshotDependenciesFiles;
    private final ImmutableList<Path> resourcesFiles;
    private final ImmutableList<Path> classesFiles;

    static MavenSourceFilesConfiguration getForProject(MavenProject project) throws IOException {
        return new MavenSourceFilesConfiguration(project);
    }

    private MavenSourceFilesConfiguration(MavenProject project) throws IOException {
        Path classesSourceDirectory = Paths.get(project.getBuild().getSourceDirectory(), new String[0]);
        Path classesOutputDirectory = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        ArrayList<Path> dependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> snapshotDependenciesFiles = new ArrayList<Path>();
        ArrayList resourcesFiles = new ArrayList();
        ArrayList classesFiles = new ArrayList();
        for (Artifact artifact : project.getArtifacts()) {
            if (artifact.isSnapshot()) {
                snapshotDependenciesFiles.add(artifact.getFile().toPath());
                continue;
            }
            dependenciesFiles.add(artifact.getFile().toPath());
        }
        try (Stream<Path> classFileStream = Files.list(classesOutputDirectory);){
            classFileStream.forEach(classFile -> {
                if (Files.isDirectory(classFile, new LinkOption[0]) && Files.exists(classesSourceDirectory.resolve(classesOutputDirectory.relativize((Path)classFile)), new LinkOption[0])) {
                    classesFiles.add(classFile);
                    return;
                }
                if (FileSystems.getDefault().getPathMatcher("glob:**.class").matches((Path)classFile)) {
                    classesFiles.add(classFile);
                    return;
                }
                resourcesFiles.add(classFile);
            });
        }
        this.dependenciesFiles = ImmutableList.sortedCopyOf(dependenciesFiles);
        this.snapshotDependenciesFiles = ImmutableList.sortedCopyOf(snapshotDependenciesFiles);
        this.resourcesFiles = ImmutableList.sortedCopyOf(resourcesFiles);
        this.classesFiles = ImmutableList.sortedCopyOf(classesFiles);
    }

    @Override
    public ImmutableList<Path> getDependenciesFiles() {
        return this.dependenciesFiles;
    }

    @Override
    public ImmutableList<Path> getSnapshotDependenciesFiles() {
        return this.snapshotDependenciesFiles;
    }

    @Override
    public ImmutableList<Path> getResourcesFiles() {
        return this.resourcesFiles;
    }

    @Override
    public ImmutableList<Path> getClassesFiles() {
        return this.classesFiles;
    }

    @Override
    public String getDependenciesPathOnImage() {
        return "/app/libs/";
    }

    @Override
    public String getResourcesPathOnImage() {
        return "/app/resources/";
    }

    @Override
    public String getClassesPathOnImage() {
        return "/app/classes/";
    }
}

