/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAliasGroup;
import com.google.cloud.tools.jib.registry.credentials.DockerConfig;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class DockerConfigCredentialRetriever {
    private static final Path DOCKER_CONFIG_FILE = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".docker").resolve("config.json");
    private final String registry;
    private final Path dockerConfigFile;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;

    public DockerConfigCredentialRetriever(String registry) {
        this(registry, DOCKER_CONFIG_FILE);
    }

    @VisibleForTesting
    DockerConfigCredentialRetriever(String registry, Path dockerConfigFile) {
        this.registry = registry;
        this.dockerConfigFile = dockerConfigFile;
        this.dockerCredentialHelperFactory = new DockerCredentialHelperFactory();
    }

    @VisibleForTesting
    DockerConfigCredentialRetriever(String registry, Path dockerConfigFile, DockerCredentialHelperFactory dockerCredentialHelperFactory) {
        this.registry = registry;
        this.dockerConfigFile = dockerConfigFile;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
    }

    @Nullable
    public Authorization retrieve() throws IOException {
        DockerConfigTemplate dockerConfigTemplate = this.loadDockerConfigTemplate();
        if (dockerConfigTemplate == null) {
            return null;
        }
        DockerConfig dockerConfig = new DockerConfig(dockerConfigTemplate);
        for (String registryAlias : RegistryAliasGroup.getAliasesGroup(this.registry)) {
            Authorization authorization = this.retrieve(dockerConfig, registryAlias);
            if (authorization == null) continue;
            return authorization;
        }
        return null;
    }

    @Nullable
    private Authorization retrieve(DockerConfig dockerConfig, String registryAlias) {
        String auth = dockerConfig.getAuthFor(registryAlias);
        if (auth != null) {
            return Authorizations.withBasicToken(auth);
        }
        DockerCredentialHelper dockerCredentialHelper = dockerConfig.getCredentialHelperFor(this.dockerCredentialHelperFactory, registryAlias);
        if (dockerCredentialHelper != null) {
            try {
                return dockerCredentialHelper.retrieve();
            }
            catch (NonexistentDockerCredentialHelperException | NonexistentServerUrlDockerCredentialHelperException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private DockerConfigTemplate loadDockerConfigTemplate() throws IOException {
        if (!Files.exists(this.dockerConfigFile, new LinkOption[0])) {
            return null;
        }
        return JsonTemplateMapper.readJsonFromFile(this.dockerConfigFile, DockerConfigTemplate.class);
    }
}

