/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStreamBuilder {
    private final LinkedHashMap<TarArchiveEntry, TarArchiveOutputStreamConsumer> archiveMap = new LinkedHashMap();

    private void writeEntriesAsTarArchive(OutputStream tarByteStream) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(tarByteStream, StandardCharsets.UTF_8.name());){
            tarArchiveOutputStream.setLongFileMode(3);
            for (Map.Entry<TarArchiveEntry, TarArchiveOutputStreamConsumer> entry : this.archiveMap.entrySet()) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry.getKey());
                entry.getValue().accept(tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public void addEntry(TarArchiveEntry entry) {
        this.archiveMap.put(entry, tarArchiveOutputStream -> {
            if (entry.isFile()) {
                BufferedInputStream contentStream = new BufferedInputStream(Files.newInputStream(entry.getFile().toPath(), new OpenOption[0]));
                Throwable throwable = null;
                try {
                    ByteStreams.copy((InputStream)contentStream, (OutputStream)tarArchiveOutputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    TarStreamBuilder.$closeResource(throwable, contentStream);
                }
            }
        });
    }

    public void addEntry(String contents, String name) {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        byte[] contentsBytes = contents.getBytes(StandardCharsets.UTF_8);
        entry.setSize((long)contentsBytes.length);
        this.archiveMap.put(entry, tarArchiveOutputStream -> tarArchiveOutputStream.write(contentsBytes));
    }

    public Blob toBlob() {
        return Blobs.from(this::writeEntriesAsTarArchive);
    }

    @FunctionalInterface
    private static interface TarArchiveOutputStreamConsumer {
        public void accept(TarArchiveOutputStream var1) throws IOException;
    }
}

