/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CacheReader;
import com.google.cloud.tools.jib.cache.CacheWriter;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements AsyncStep<CachedLayerWithMetadata>,
Callable<CachedLayerWithMetadata> {
    private static final String DESCRIPTION = "Building application layers";
    private final String layerType;
    private final BuildConfiguration buildConfiguration;
    private final LayerConfiguration layerConfiguration;
    private final Cache cache;
    private final ListenableFuture<CachedLayerWithMetadata> listenableFuture;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, Cache cache) {
        try (Timer ignored = new Timer(buildConfiguration.getBuildLogger(), DESCRIPTION);){
            ImmutableList.Builder buildAndCacheApplicationLayerSteps = ImmutableList.builderWithExpectedSize((int)buildConfiguration.getLayerConfigurations().size());
            for (LayerConfiguration layerConfiguration : buildConfiguration.getLayerConfigurations()) {
                if (layerConfiguration.getLayerEntries().stream().allMatch(layerEntry -> layerEntry.getSourceFiles().isEmpty())) continue;
                buildAndCacheApplicationLayerSteps.add((Object)new BuildAndCacheApplicationLayerStep(layerConfiguration.getLabel(), listeningExecutorService, buildConfiguration, layerConfiguration, cache));
            }
            UnmodifiableIterator unmodifiableIterator = buildAndCacheApplicationLayerSteps.build();
            return unmodifiableIterator;
        }
    }

    private BuildAndCacheApplicationLayerStep(String layerType, ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, LayerConfiguration layerConfiguration, Cache cache) {
        this.layerType = layerType;
        this.buildConfiguration = buildConfiguration;
        this.layerConfiguration = layerConfiguration;
        this.cache = cache;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<CachedLayerWithMetadata> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public CachedLayerWithMetadata call() throws IOException, CacheMetadataCorruptedException {
        String description = "Building " + this.layerType + " layer";
        this.buildConfiguration.getBuildLogger().lifecycle(description + "...");
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), description);){
            CachedLayerWithMetadata cachedLayer = new CacheReader(this.cache).getUpToDateLayerByLayerEntries(this.layerConfiguration.getLayerEntries());
            if (cachedLayer != null) {
                CachedLayerWithMetadata cachedLayerWithMetadata = cachedLayer;
                return cachedLayerWithMetadata;
            }
            ReproducibleLayerBuilder reproducibleLayerBuilder = new ReproducibleLayerBuilder();
            for (LayerEntry layerEntry : this.layerConfiguration.getLayerEntries()) {
                reproducibleLayerBuilder.addFiles((List<Path>)layerEntry.getSourceFiles(), layerEntry.getExtractionPath());
            }
            cachedLayer = new CacheWriter(this.cache).writeLayer(reproducibleLayerBuilder);
            this.buildConfiguration.getBuildLogger().debug(description + " built " + cachedLayer.getBlobDescriptor().getDigest());
            Object object = cachedLayer;
            return object;
        }
    }
}

