/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class BuildConfiguration {
    private final JibLogger buildLogger;
    private final ImageConfiguration baseImageConfiguration;
    private final ImageConfiguration targetImageConfiguration;
    @Nullable
    private final ContainerConfiguration containerConfiguration;
    @Nullable
    private final CacheConfiguration applicationLayersCacheConfiguration;
    @Nullable
    private final CacheConfiguration baseImageLayersCacheConfiguration;
    private Class<? extends BuildableManifestTemplate> targetFormat;
    private final boolean allowInsecureRegistries;
    private final ImmutableList<LayerConfiguration> layerConfigurations;

    public static Builder builder(JibLogger buildLogger) {
        return new Builder(buildLogger);
    }

    private BuildConfiguration(JibLogger buildLogger, ImageConfiguration baseImageConfiguration, ImageConfiguration targetImageConfiguration, @Nullable ContainerConfiguration containerConfiguration, @Nullable CacheConfiguration applicationLayersCacheConfiguration, @Nullable CacheConfiguration baseImageLayersCacheConfiguration, Class<? extends BuildableManifestTemplate> targetFormat, boolean allowInsecureRegistries, ImmutableList<LayerConfiguration> layerConfigurations) {
        this.buildLogger = buildLogger;
        this.baseImageConfiguration = baseImageConfiguration;
        this.targetImageConfiguration = targetImageConfiguration;
        this.containerConfiguration = containerConfiguration;
        this.applicationLayersCacheConfiguration = applicationLayersCacheConfiguration;
        this.baseImageLayersCacheConfiguration = baseImageLayersCacheConfiguration;
        this.targetFormat = targetFormat;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.layerConfigurations = layerConfigurations;
    }

    public JibLogger getBuildLogger() {
        return this.buildLogger;
    }

    public ImageConfiguration getBaseImageConfiguration() {
        return this.baseImageConfiguration;
    }

    public ImageConfiguration getTargetImageConfiguration() {
        return this.targetImageConfiguration;
    }

    @Nullable
    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    @Nullable
    public CacheConfiguration getApplicationLayersCacheConfiguration() {
        return this.applicationLayersCacheConfiguration;
    }

    @Nullable
    public CacheConfiguration getBaseImageLayersCacheConfiguration() {
        return this.baseImageLayersCacheConfiguration;
    }

    public boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    public ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return this.layerConfigurations;
    }

    public static class Builder {
        @Nullable
        private ImageConfiguration baseImageConfiguration;
        @Nullable
        private ImageConfiguration targetImageConfiguration;
        @Nullable
        private ContainerConfiguration containerConfiguration;
        @Nullable
        private CacheConfiguration applicationLayersCacheConfiguration;
        @Nullable
        private CacheConfiguration baseImageLayersCacheConfiguration;
        private boolean allowInsecureRegistries = false;
        private ImmutableList<LayerConfiguration> layerConfigurations = ImmutableList.of();
        private Class<? extends BuildableManifestTemplate> targetFormat = V22ManifestTemplate.class;
        private JibLogger buildLogger;

        private Builder(JibLogger buildLogger) {
            this.buildLogger = buildLogger;
        }

        public Builder setBaseImageConfiguration(ImageConfiguration imageConfiguration) {
            this.baseImageConfiguration = imageConfiguration;
            return this;
        }

        public Builder setTargetImageConfiguration(ImageConfiguration imageConfiguration) {
            this.targetImageConfiguration = imageConfiguration;
            return this;
        }

        public Builder setContainerConfiguration(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return this;
        }

        public Builder setApplicationLayersCacheConfiguration(@Nullable CacheConfiguration applicationLayersCacheConfiguration) {
            this.applicationLayersCacheConfiguration = applicationLayersCacheConfiguration;
            return this;
        }

        public Builder setBaseImageLayersCacheConfiguration(@Nullable CacheConfiguration baseImageLayersCacheConfiguration) {
            this.baseImageLayersCacheConfiguration = baseImageLayersCacheConfiguration;
            return this;
        }

        public Builder setTargetFormat(Class<? extends BuildableManifestTemplate> targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        public Builder setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Builder setLayerConfigurations(List<LayerConfiguration> layerConfigurations) {
            this.layerConfigurations = ImmutableList.copyOf(layerConfigurations);
            return this;
        }

        public BuildConfiguration build() {
            ArrayList<String> errorMessages = new ArrayList<String>();
            if (this.baseImageConfiguration == null) {
                errorMessages.add("base image configuration is required but not set");
            }
            if (this.targetImageConfiguration == null) {
                errorMessages.add("target image configuration is required but not set");
            }
            switch (errorMessages.size()) {
                case 0: {
                    if (this.baseImageConfiguration == null || this.targetImageConfiguration == null) {
                        throw new IllegalStateException("Required fields should not be null");
                    }
                    if (this.baseImageConfiguration.getImage().usesDefaultTag()) {
                        this.buildLogger.warn("Base image '" + this.baseImageConfiguration.getImage() + "' does not use a specific image digest - build may not be reproducible");
                    }
                    return new BuildConfiguration(this.buildLogger, this.baseImageConfiguration, this.targetImageConfiguration, this.containerConfiguration, this.applicationLayersCacheConfiguration, this.baseImageLayersCacheConfiguration, this.targetFormat, this.allowInsecureRegistries, this.layerConfigurations);
                }
                case 1: {
                    throw new IllegalStateException((String)errorMessages.get(0));
                }
                case 2: {
                    throw new IllegalStateException((String)errorMessages.get(0) + " and " + (String)errorMessages.get(1));
                }
            }
            throw new IllegalStateException();
        }
    }
}

