/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import javax.annotation.Nullable;

public class ImageConfiguration {
    private final ImageReference image;
    @Nullable
    private final String credentialHelper;
    @Nullable
    private final RegistryCredentials knownRegistryCredentials;

    public static Builder builder(ImageReference imageReference) {
        return new Builder(imageReference);
    }

    private ImageConfiguration(ImageReference image, @Nullable String credentialHelper, @Nullable RegistryCredentials knownRegistryCredentials) {
        this.image = image;
        this.credentialHelper = credentialHelper;
        this.knownRegistryCredentials = knownRegistryCredentials;
    }

    public ImageReference getImage() {
        return this.image;
    }

    public String getImageRegistry() {
        return this.image.getRegistry();
    }

    public String getImageRepository() {
        return this.image.getRepository();
    }

    public String getImageTag() {
        return this.image.getTag();
    }

    @Nullable
    public String getCredentialHelper() {
        return this.credentialHelper;
    }

    @Nullable
    public RegistryCredentials getKnownRegistryCredentials() {
        return this.knownRegistryCredentials;
    }

    public static class Builder {
        private ImageReference imageReference;
        @Nullable
        private String credentialHelper;
        @Nullable
        private RegistryCredentials knownRegistryCredentials;

        public Builder setCredentialHelper(@Nullable String credentialHelper) {
            this.credentialHelper = credentialHelper;
            return this;
        }

        public Builder setKnownRegistryCredentials(@Nullable RegistryCredentials knownRegistryCredentials) {
            this.knownRegistryCredentials = knownRegistryCredentials;
            return this;
        }

        public ImageConfiguration build() {
            return new ImageConfiguration(this.imageReference, this.credentialHelper, this.knownRegistryCredentials);
        }

        private Builder(ImageReference imageReference) {
            this.imageReference = imageReference;
        }
    }
}

